/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import io.aeron.shadow.org.HdrHistogram.Histogram;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.agrona.SystemUtil;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.ShutdownSignalBarrier;

public class BurstSendReceiveUdpPing {
    public static void main(String[] args) throws IOException {
        String remoteHost = "localhost";
        if (1 <= args.length) {
            remoteHost = args[0];
        }
        int packetSize = 16;
        if (2 <= args.length) {
            packetSize = Math.min(1408, Math.max(packetSize, Integer.parseInt(args[1])));
        }
        int burstSize = 1;
        if (3 <= args.length) {
            burstSize = Math.min(1024, Integer.parseInt(args[2]));
        }
        if (SystemUtil.isWindows()) {
            HighResolutionTimer.enable();
        }
        System.out.printf("Remote host: %s, packet size: %d, burstSize: %d%n", remoteHost, packetSize, burstSize);
        Histogram histogram = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1408);
        int length = buffer.capacity();
        for (int i = 0; i < length; ++i) {
            buffer.put(i, (byte)-1);
        }
        DatagramChannel receiveChannel = DatagramChannel.open();
        receiveChannel.bind(new InetSocketAddress("0.0.0.0", 20123));
        InetSocketAddress sendAddress = new InetSocketAddress(remoteHost, 20124);
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        AtomicBoolean running = new AtomicBoolean(true);
        try (ShutdownSignalBarrier ignore = new ShutdownSignalBarrier(() -> running.set(false));){
            while (running.get()) {
                BurstSendReceiveUdpPing.measureRoundTrip(histogram, sendAddress, buffer, packetSize, burstSize, receiveChannel, sendChannel, running);
                histogram.reset();
                System.gc();
                LockSupport.parkNanos(1000000000L);
            }
        }
    }

    private static void measureRoundTrip(Histogram histogram, InetSocketAddress sendAddress, ByteBuffer buffer, int packetSize, int burstSize, DatagramChannel receiveChannel, DatagramChannel sendChannel, AtomicBoolean running) throws IOException {
        for (int sequenceNumber = 0; sequenceNumber < 10000; sequenceNumber += burstSize) {
            int i;
            for (i = 0; i < burstSize; ++i) {
                long timestampNs = System.nanoTime();
                buffer.clear();
                buffer.putLong(sequenceNumber + i);
                buffer.putLong(timestampNs);
                buffer.position(packetSize);
                buffer.flip();
                sendChannel.send(buffer, sendAddress);
            }
            for (i = 0; i < burstSize; ++i) {
                buffer.clear();
                while (running.get() && null == receiveChannel.receive(buffer)) {
                    Thread.onSpinWait();
                }
                long receivedSequenceNumber = buffer.getLong(0);
                if (receivedSequenceNumber != (long)(sequenceNumber + i)) {
                    throw new IllegalStateException("Data Loss: " + sequenceNumber + " to " + receivedSequenceNumber);
                }
                long durationNs = System.nanoTime() - buffer.getLong(8);
                histogram.recordValue(durationNs);
            }
        }
        histogram.outputPercentileDistribution(System.out, 1000.0);
    }
}

