/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.security;

import io.aeron.security.Authenticator;
import io.aeron.security.SessionProxy;
import java.util.ArrayList;
import java.util.Arrays;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.Object2ObjectHashMap;

public final class SimpleAuthenticator
implements Authenticator {
    private final Object2ObjectHashMap<Credentials, Principal> principalsByCredentialsMap = new Object2ObjectHashMap();
    private final Long2ObjectHashMap<Principal> authenticatedSessionIdToPrincipalMap = new Long2ObjectHashMap();

    private SimpleAuthenticator(Builder builder) {
        for (Principal principal : builder.principals) {
            this.principalsByCredentialsMap.put(principal.credentials, principal);
        }
    }

    @Override
    public void onConnectRequest(long sessionId, byte[] encodedCredentials, long nowMs) {
        Principal principal = this.principalsByCredentialsMap.get(new Credentials(encodedCredentials));
        if (null != principal && principal.credentialsMatch(encodedCredentials)) {
            this.authenticatedSessionIdToPrincipalMap.put(sessionId, principal);
        }
    }

    @Override
    public void onChallengeResponse(long sessionId, byte[] encodedCredentials, long nowMs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onConnectedSession(SessionProxy sessionProxy, long nowMs) {
        long sessionId = sessionProxy.sessionId();
        Principal principal = this.authenticatedSessionIdToPrincipalMap.get(sessionId);
        if (null != principal) {
            if (sessionProxy.authenticate(principal.encodedPrincipal)) {
                this.authenticatedSessionIdToPrincipalMap.remove(sessionId);
            }
        } else {
            sessionProxy.reject();
        }
    }

    @Override
    public void onChallengedSession(SessionProxy sessionProxy, long nowMs) {
        throw new UnsupportedOperationException();
    }

    public static class Builder {
        private final ArrayList<Principal> principals = new ArrayList();

        public Builder principal(byte[] encodedPrincipal, byte[] encodedCredentials) {
            this.principals.add(new Principal(encodedPrincipal, encodedCredentials));
            return this;
        }

        public SimpleAuthenticator newInstance() {
            return new SimpleAuthenticator(this);
        }
    }

    private static final class Principal {
        private final byte[] encodedPrincipal;
        private final Credentials credentials;

        private Principal(byte[] encodedPrincipal, byte[] encodedCredentials) {
            this.encodedPrincipal = encodedPrincipal;
            this.credentials = new Credentials(encodedCredentials);
        }

        public boolean credentialsMatch(byte[] encodedCredentials) {
            return Arrays.equals(this.credentials.encodedCredentials, encodedCredentials);
        }
    }

    private static final class Credentials {
        private final byte[] encodedCredentials;

        private Credentials(byte[] encodedCredentials) {
            this.encodedCredentials = encodedCredentials;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Credentials that = (Credentials)o;
            return Arrays.equals(this.encodedCredentials, that.encodedCredentials);
        }

        public int hashCode() {
            return Arrays.hashCode(this.encodedCredentials);
        }
    }
}

