/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableCounterHandler;
import io.aeron.AvailableImageHandler;
import io.aeron.ClientConductor;
import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.ConcurrentPublication;
import io.aeron.Counter;
import io.aeron.DriverProxy;
import io.aeron.ExclusivePublication;
import io.aeron.LogBuffersFactory;
import io.aeron.MappedLogBuffersFactory;
import io.aeron.PublicationErrorFrameHandler;
import io.aeron.Subscription;
import io.aeron.UnavailableCounterHandler;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.SleepingMillisIdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.broadcast.BroadcastReceiver;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class Aeron
implements AutoCloseable {
    public static final int NULL_VALUE = -1;
    private static final VarHandle IS_CLOSED_VH;
    private volatile boolean isClosed;
    private final long clientId;
    private final ClientConductor conductor;
    private final RingBuffer commandBuffer;
    private final AgentInvoker conductorInvoker;
    private final AgentRunner conductorRunner;
    private final Context ctx;

    Aeron(Context ctx) {
        try {
            ctx.conclude();
            this.ctx = ctx;
            this.clientId = ctx.clientId();
            this.commandBuffer = ctx.toDriverBuffer();
            this.conductor = new ClientConductor(ctx, this);
            if (ctx.useConductorAgentInvoker()) {
                this.conductorInvoker = new AgentInvoker(ctx.errorHandler(), null, this.conductor);
                this.conductorRunner = null;
            } else {
                this.conductorInvoker = null;
                this.conductorRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), null, this.conductor);
            }
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static Aeron connect() {
        return Aeron.connect(new Context());
    }

    public static Aeron connect(Context ctx) {
        try {
            Aeron aeron = new Aeron(ctx);
            if (ctx.useConductorAgentInvoker()) {
                aeron.conductorInvoker.start();
            } else {
                AgentRunner.startOnThread(aeron.conductorRunner, ctx.threadFactory());
            }
            return aeron;
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ctx.close();
            throw ex;
        }
    }

    public void printCounters(PrintStream out) {
        CountersReader counters = this.countersReader();
        counters.forEach((value, id, label) -> out.format("%3d: %,20d - %s%n", id, value, label));
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Context context() {
        return this.ctx;
    }

    public long clientId() {
        return this.clientId;
    }

    public AgentInvoker conductorAgentInvoker() {
        return this.conductorInvoker;
    }

    public boolean isCommandActive(long correlationId) {
        return this.conductor.isCommandActive(correlationId);
    }

    public boolean hasActiveCommands() {
        return this.conductor.hasActiveCommands();
    }

    @Override
    public void close() {
        if (IS_CLOSED_VH.compareAndSet(this, false, true)) {
            ErrorHandler errorHandler = this.ctx.errorHandler();
            if (null != this.conductorRunner) {
                CloseHelper.close(errorHandler, this.conductorRunner);
            } else {
                CloseHelper.close(errorHandler, this.conductorInvoker);
            }
        }
    }

    public ConcurrentPublication addPublication(String channel, int streamId) {
        return this.conductor.addPublication(channel, streamId);
    }

    public ExclusivePublication addExclusivePublication(String channel, int streamId) {
        return this.conductor.addExclusivePublication(channel, streamId);
    }

    public long asyncAddPublication(String channel, int streamId) {
        return this.conductor.asyncAddPublication(channel, streamId);
    }

    public long asyncAddExclusivePublication(String channel, int streamId) {
        return this.conductor.asyncAddExclusivePublication(channel, streamId);
    }

    public void asyncRemovePublication(long registrationId) {
        this.conductor.removePublication(registrationId);
    }

    public ConcurrentPublication getPublication(long registrationId) {
        return this.conductor.getPublication(registrationId);
    }

    public ExclusivePublication getExclusivePublication(long registrationId) {
        return this.conductor.getExclusivePublication(registrationId);
    }

    public Subscription addSubscription(String channel, int streamId) {
        return this.conductor.addSubscription(channel, streamId);
    }

    public Subscription addSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        return this.conductor.addSubscription(channel, streamId, availableImageHandler, unavailableImageHandler);
    }

    public long asyncAddSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        return this.conductor.asyncAddSubscription(channel, streamId, availableImageHandler, unavailableImageHandler);
    }

    public long asyncAddSubscription(String channel, int streamId) {
        return this.conductor.asyncAddSubscription(channel, streamId);
    }

    public void asyncRemoveSubscription(long registrationId) {
        this.conductor.removeSubscription(registrationId);
    }

    public Subscription getSubscription(long registrationId) {
        return this.conductor.getSubscription(registrationId);
    }

    public long nextCorrelationId() {
        if (this.isClosed) {
            throw new AeronException("client is closed");
        }
        return this.commandBuffer.nextCorrelationId();
    }

    public int nextSessionId(int streamId) {
        if (this.isClosed) {
            throw new AeronException("client is closed");
        }
        return this.conductor.nextSessionId(streamId);
    }

    public CountersReader countersReader() {
        if (this.isClosed) {
            throw new AeronException("client is closed");
        }
        return this.conductor.countersReader();
    }

    public Counter addCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        return this.conductor.addCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
    }

    public Counter addCounter(int typeId, String label) {
        return this.conductor.addCounter(typeId, label);
    }

    public Counter addStaticCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength, long registrationId) {
        return this.conductor.addStaticCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength, registrationId);
    }

    public Counter addStaticCounter(int typeId, String label, long registrationId) {
        return this.conductor.addStaticCounter(typeId, label, registrationId);
    }

    public long asyncAddCounter(int typeId, String label) {
        return this.conductor.asyncAddCounter(typeId, label);
    }

    public long asyncAddCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        return this.conductor.asyncAddCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
    }

    public long asyncAddStaticCounter(int typeId, String label, long registrationId) {
        return this.conductor.asyncAddStaticCounter(typeId, label, registrationId);
    }

    public long asyncAddStaticCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength, long registrationId) {
        return this.conductor.asyncAddStaticCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength, registrationId);
    }

    public Counter getCounter(long correlationId) {
        return this.conductor.getCounter(correlationId);
    }

    public void asyncRemoveCounter(long registrationId) {
        this.conductor.asyncRemoveCounter(registrationId);
    }

    public long addAvailableCounterHandler(AvailableCounterHandler handler) {
        return this.conductor.addAvailableCounterHandler(handler);
    }

    public boolean removeAvailableCounterHandler(long registrationId) {
        return this.conductor.removeAvailableCounterHandler(registrationId);
    }

    @Deprecated
    public boolean removeAvailableCounterHandler(AvailableCounterHandler handler) {
        return this.conductor.removeAvailableCounterHandler(handler);
    }

    public long addUnavailableCounterHandler(UnavailableCounterHandler handler) {
        return this.conductor.addUnavailableCounterHandler(handler);
    }

    public boolean removeUnavailableCounterHandler(long registrationId) {
        return this.conductor.removeUnavailableCounterHandler(registrationId);
    }

    @Deprecated
    public boolean removeUnavailableCounterHandler(UnavailableCounterHandler handler) {
        return this.conductor.removeUnavailableCounterHandler(handler);
    }

    public long addCloseHandler(Runnable handler) {
        return this.conductor.addCloseHandler(handler);
    }

    public boolean removeCloseHandler(long registrationId) {
        return this.conductor.removeCloseHandler(registrationId);
    }

    @Deprecated
    public boolean removeCloseHandler(Runnable handler) {
        return this.conductor.removeCloseHandler(handler);
    }

    public String toString() {
        return "Aeron{isClosed=" + this.isClosed + ", clientId=" + this.clientId + "}";
    }

    void internalClose() {
        this.isClosed = true;
    }

    static {
        try {
            IS_CLOSED_VH = MethodHandles.lookup().findVarHandle(Aeron.class, "isClosed", Boolean.TYPE);
        }
        catch (ReflectiveOperationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static class Context
    extends CommonContext {
        private long clientId;
        private String clientName = Configuration.clientName();
        private boolean useConductorAgentInvoker = false;
        private boolean preTouchMappedMemory = Configuration.preTouchMappedMemory();
        private AgentInvoker driverAgentInvoker;
        private Lock clientLock;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private IdleStrategy idleStrategy;
        private IdleStrategy awaitingIdleStrategy;
        private CopyBroadcastReceiver toClientBuffer;
        private RingBuffer toDriverBuffer;
        private DriverProxy driverProxy;
        private ByteBuffer cncByteBuffer;
        private AtomicBuffer cncMetaDataBuffer;
        private LogBuffersFactory logBuffersFactory;
        private ErrorHandler errorHandler;
        private ErrorHandler subscriberErrorHandler;
        private AvailableImageHandler availableImageHandler;
        private UnavailableImageHandler unavailableImageHandler;
        private AvailableCounterHandler availableCounterHandler;
        private UnavailableCounterHandler unavailableCounterHandler;
        private PublicationErrorFrameHandler publicationErrorFrameHandler = PublicationErrorFrameHandler.NO_OP;
        private Runnable closeHandler;
        private long keepAliveIntervalNs = Configuration.KEEPALIVE_INTERVAL_NS;
        private long interServiceTimeoutNs;
        private long idleSleepDurationNs = Configuration.idleSleepDurationNs();
        private long resourceLingerDurationNs = Configuration.resourceLingerDurationNs();
        private long closeLingerDurationNs = Configuration.closeLingerDurationNs();
        private int filePageSize;
        private ThreadFactory threadFactory = Thread::new;

        @Override
        public Context clone() {
            return (Context)super.clone();
        }

        @Override
        public Context conclude() {
            super.conclude();
            if (null == this.clientLock) {
                this.clientLock = new ReentrantLock();
            } else if (this.clientLock instanceof NoOpLock && !this.useConductorAgentInvoker) {
                throw new ConfigurationException("Must use Aeron.Context.useConductorAgentInvoker(true) when Aeron.Context.clientLock(...) is using a NoOpLock");
            }
            if (null != this.driverAgentInvoker && !this.useConductorAgentInvoker) {
                throw new ConfigurationException("Must use Aeron.Context.useConductorAgentInvoker(true) when Aeron.Context.driverAgentInvoker() is set");
            }
            if (this.clientName.length() > 100) {
                throw new ConfigurationException("clientName length must <= 100");
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.nanoClock) {
                this.nanoClock = SystemNanoClock.INSTANCE;
            }
            if (this.idleSleepDurationNs < 0L || this.idleSleepDurationNs > TimeUnit.SECONDS.toNanos(1L)) {
                throw new ConfigurationException("Invalid idle sleep duration: " + this.idleSleepDurationNs + "ns");
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new SleepingMillisIdleStrategy(TimeUnit.NANOSECONDS.toMillis(this.idleSleepDurationNs));
            }
            if (null == this.awaitingIdleStrategy) {
                this.awaitingIdleStrategy = new SleepingMillisIdleStrategy(1L);
            }
            this.connectToDriver();
            this.filePageSize = Context.driverFilePageSize(this.cncMetaDataBuffer);
            this.interServiceTimeoutNs = CncFileDescriptor.clientLivenessTimeoutNs(this.cncMetaDataBuffer);
            if (this.interServiceTimeoutNs <= this.keepAliveIntervalNs) {
                throw new ConfigurationException("interServiceTimeoutNs=" + this.interServiceTimeoutNs + " <= keepAliveIntervalNs=" + this.keepAliveIntervalNs);
            }
            if (null == this.toDriverBuffer) {
                this.toDriverBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            }
            if (null == this.toClientBuffer) {
                this.toClientBuffer = new CopyBroadcastReceiver(new BroadcastReceiver(CncFileDescriptor.createToClientsBuffer(this.cncByteBuffer, this.cncMetaDataBuffer)), new ExpandableArrayBuffer(4096));
            }
            if (this.countersMetaDataBuffer() == null) {
                this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            }
            if (this.countersValuesBuffer() == null) {
                this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            }
            if (null == this.logBuffersFactory) {
                this.logBuffersFactory = new MappedLogBuffersFactory();
            }
            if (null == this.errorHandler) {
                this.errorHandler = Configuration.DEFAULT_ERROR_HANDLER;
            }
            if (null == this.subscriberErrorHandler) {
                this.subscriberErrorHandler = this.errorHandler;
            }
            if (null == this.driverProxy) {
                this.clientId = this.toDriverBuffer.nextCorrelationId();
                this.driverProxy = new DriverProxy(this.toDriverBuffer, this.clientId);
            }
            return this;
        }

        public long clientId() {
            return this.clientId;
        }

        public Context clientName(String clientName) {
            this.clientName = Strings.isEmpty(clientName) ? "" : clientName;
            return this;
        }

        public String clientName() {
            return this.clientName;
        }

        public Context useConductorAgentInvoker(boolean useConductorAgentInvoker) {
            this.useConductorAgentInvoker = useConductorAgentInvoker;
            return this;
        }

        public boolean useConductorAgentInvoker() {
            return this.useConductorAgentInvoker;
        }

        public Context preTouchMappedMemory(boolean preTouchMappedMemory) {
            this.preTouchMappedMemory = preTouchMappedMemory;
            return this;
        }

        public boolean preTouchMappedMemory() {
            return this.preTouchMappedMemory;
        }

        public Context driverAgentInvoker(AgentInvoker driverAgentInvoker) {
            this.driverAgentInvoker = driverAgentInvoker;
            return this;
        }

        public AgentInvoker driverAgentInvoker() {
            return this.driverAgentInvoker;
        }

        public Context clientLock(Lock lock) {
            this.clientLock = lock;
            return this;
        }

        public Lock clientLock() {
            return this.clientLock;
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context awaitingIdleStrategy(IdleStrategy idleStrategy) {
            this.awaitingIdleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy awaitingIdleStrategy() {
            return this.awaitingIdleStrategy;
        }

        Context toClientBuffer(CopyBroadcastReceiver toClientBuffer) {
            this.toClientBuffer = toClientBuffer;
            return this;
        }

        public CopyBroadcastReceiver toClientBuffer() {
            return this.toClientBuffer;
        }

        public RingBuffer toDriverBuffer() {
            return this.toDriverBuffer;
        }

        Context driverProxy(DriverProxy driverProxy) {
            this.driverProxy = driverProxy;
            return this;
        }

        public DriverProxy driverProxy() {
            return this.driverProxy;
        }

        Context logBuffersFactory(LogBuffersFactory logBuffersFactory) {
            this.logBuffersFactory = logBuffersFactory;
            return this;
        }

        LogBuffersFactory logBuffersFactory() {
            return this.logBuffersFactory;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context subscriberErrorHandler(ErrorHandler errorHandler) {
            this.subscriberErrorHandler = errorHandler;
            return this;
        }

        public ErrorHandler subscriberErrorHandler() {
            return this.subscriberErrorHandler;
        }

        public Context availableImageHandler(AvailableImageHandler handler) {
            this.availableImageHandler = handler;
            return this;
        }

        public AvailableImageHandler availableImageHandler() {
            return this.availableImageHandler;
        }

        public Context unavailableImageHandler(UnavailableImageHandler handler) {
            this.unavailableImageHandler = handler;
            return this;
        }

        public UnavailableImageHandler unavailableImageHandler() {
            return this.unavailableImageHandler;
        }

        public Context availableCounterHandler(AvailableCounterHandler handler) {
            this.availableCounterHandler = handler;
            return this;
        }

        public AvailableCounterHandler availableCounterHandler() {
            return this.availableCounterHandler;
        }

        public Context unavailableCounterHandler(UnavailableCounterHandler handler) {
            this.unavailableCounterHandler = handler;
            return this;
        }

        public UnavailableCounterHandler unavailableCounterHandler() {
            return this.unavailableCounterHandler;
        }

        public Context closeHandler(Runnable handler) {
            this.closeHandler = handler;
            return this;
        }

        public Runnable closeHandler() {
            return this.closeHandler;
        }

        public Context keepAliveIntervalNs(long value) {
            this.keepAliveIntervalNs = value;
            return this;
        }

        public long keepAliveIntervalNs() {
            return this.keepAliveIntervalNs;
        }

        @Override
        public Context driverTimeoutMs(long value) {
            super.driverTimeoutMs(value);
            return this;
        }

        Context interServiceTimeoutNs(long interServiceTimeout) {
            this.interServiceTimeoutNs = interServiceTimeout;
            return this;
        }

        public long interServiceTimeoutNs() {
            return CommonContext.checkDebugTimeout(this.interServiceTimeoutNs, TimeUnit.NANOSECONDS);
        }

        public Context idleSleepDurationNs(long idleSleepDurationNs) {
            this.idleSleepDurationNs = idleSleepDurationNs;
            return this;
        }

        public long idleSleepDurationNs() {
            return this.idleSleepDurationNs;
        }

        public Context resourceLingerDurationNs(long resourceLingerDurationNs) {
            this.resourceLingerDurationNs = resourceLingerDurationNs;
            return this;
        }

        public long resourceLingerDurationNs() {
            return this.resourceLingerDurationNs;
        }

        public Context closeLingerDurationNs(long closeLingerDurationNs) {
            this.closeLingerDurationNs = closeLingerDurationNs;
            return this;
        }

        public long closeLingerDurationNs() {
            return this.closeLingerDurationNs;
        }

        @Override
        public Context aeronDirectoryName(String dirName) {
            super.aeronDirectoryName(dirName);
            return this;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public Context publicationErrorFrameHandler(PublicationErrorFrameHandler publicationErrorFrameHandler) {
            this.publicationErrorFrameHandler = Objects.requireNonNull(publicationErrorFrameHandler);
            return this;
        }

        public PublicationErrorFrameHandler publicationErrorFrameHandler() {
            return this.publicationErrorFrameHandler;
        }

        public int filePageSize() {
            return this.filePageSize;
        }

        @Override
        public void close() {
            BufferUtil.free(this.cncByteBuffer);
            this.cncByteBuffer = null;
            super.close();
        }

        public String toString() {
            return "Aeron.Context\n{\n    isConcluded=" + this.isConcluded() + "\n    aeronDirectory=" + String.valueOf(this.aeronDirectory()) + "\n    aeronDirectoryName='" + this.aeronDirectoryName() + "'\n    cncFile=" + String.valueOf(this.cncFile()) + "\n    countersMetaDataBuffer=" + String.valueOf(this.countersMetaDataBuffer()) + "\n    countersValuesBuffer=" + String.valueOf(this.countersValuesBuffer()) + "\n    driverTimeoutMs=" + this.driverTimeoutMs() + "\n    clientId=" + this.clientId + "\n    clientName=" + this.clientName + "\n    useConductorAgentInvoker=" + this.useConductorAgentInvoker + "\n    preTouchMappedMemory=" + this.preTouchMappedMemory + "\n    driverAgentInvoker=" + String.valueOf(this.driverAgentInvoker) + "\n    clientLock=" + String.valueOf(this.clientLock) + "\n    epochClock=" + String.valueOf(this.epochClock) + "\n    nanoClock=" + String.valueOf(this.nanoClock) + "\n    idleStrategy=" + String.valueOf(this.idleStrategy) + "\n    awaitingIdleStrategy=" + String.valueOf(this.awaitingIdleStrategy) + "\n    toClientBuffer=" + String.valueOf(this.toClientBuffer) + "\n    toDriverBuffer=" + String.valueOf(this.toDriverBuffer) + "\n    driverProxy=" + String.valueOf(this.driverProxy) + "\n    cncByteBuffer=" + String.valueOf(this.cncByteBuffer) + "\n    cncMetaDataBuffer=" + String.valueOf(this.cncMetaDataBuffer) + "\n    logBuffersFactory=" + String.valueOf(this.logBuffersFactory) + "\n    errorHandler=" + String.valueOf(this.errorHandler) + "\n    subscriberErrorHandler=" + String.valueOf(this.subscriberErrorHandler) + "\n    availableImageHandler=" + String.valueOf(this.availableImageHandler) + "\n    unavailableImageHandler=" + String.valueOf(this.unavailableImageHandler) + "\n    availableCounterHandler=" + String.valueOf(this.availableCounterHandler) + "\n    unavailableCounterHandler=" + String.valueOf(this.unavailableCounterHandler) + "\n    closeHandler=" + String.valueOf(this.closeHandler) + "\n    keepAliveIntervalNs=" + this.keepAliveIntervalNs + "\n    interServiceTimeoutNs=" + this.interServiceTimeoutNs + "\n    resourceLingerDurationNs=" + this.resourceLingerDurationNs + "\n    closeLingerDurationNs=" + this.closeLingerDurationNs + "\n    threadFactory=" + String.valueOf(this.threadFactory) + "\n}";
        }

        private void connectToDriver() {
            EpochClock clock = this.epochClock;
            long deadlineMs = clock.time() + this.driverTimeoutMs();
            File cncFile = this.cncFile();
            while (null == this.toDriverBuffer) {
                this.cncMetaDataBuffer = Context.awaitCncFileCreation(cncFile, clock, deadlineMs);
                this.cncByteBuffer = this.cncMetaDataBuffer.byteBuffer();
                if (!CncFileDescriptor.isCncFileLengthSufficient(this.cncMetaDataBuffer, this.cncByteBuffer.capacity())) {
                    BufferUtil.free(this.cncByteBuffer);
                    this.cncByteBuffer = null;
                    this.cncMetaDataBuffer = null;
                    Context.sleep(1L);
                    continue;
                }
                ManyToOneRingBuffer ringBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
                while (0L == ringBuffer.consumerHeartbeatTime()) {
                    if (clock.time() > deadlineMs) {
                        throw new DriverTimeoutException("no driver heartbeat detected");
                    }
                    Context.sleep(1L);
                }
                long timeMs = clock.time();
                if (ringBuffer.consumerHeartbeatTime() < timeMs - this.driverTimeoutMs()) {
                    if (timeMs > deadlineMs) {
                        throw new DriverTimeoutException("no driver heartbeat detected");
                    }
                    BufferUtil.free(this.cncByteBuffer);
                    this.cncByteBuffer = null;
                    this.cncMetaDataBuffer = null;
                    Context.sleep(100L);
                    continue;
                }
                this.toDriverBuffer = ringBuffer;
            }
        }
    }

    public static class Configuration {
        static final long IDLE_SLEEP_DEFAULT_MS = 16L;
        static final long AWAITING_IDLE_SLEEP_MS = 1L;
        public static final String IDLE_SLEEP_DURATION_PROP_NAME = "aeron.client.idle.sleep.duration";
        static final long IDLE_SLEEP_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(16L);
        static final long KEEPALIVE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(500L);
        public static final String RESOURCE_LINGER_DURATION_PROP_NAME = "aeron.client.resource.linger.duration";
        public static final long RESOURCE_LINGER_DURATION_DEFAULT_NS = TimeUnit.SECONDS.toNanos(3L);
        public static final String CLOSE_LINGER_DURATION_PROP_NAME = "aeron.client.close.linger.duration";
        public static final long CLOSE_LINGER_DURATION_DEFAULT_NS = 0L;
        public static final String PRE_TOUCH_MAPPED_MEMORY_PROP_NAME = "aeron.pre.touch.mapped.memory";
        public static final boolean PRE_TOUCH_MAPPED_MEMORY_DEFAULT = false;
        public static final String CLIENT_NAME_PROP_NAME = "aeron.client.name";
        public static final ErrorHandler DEFAULT_ERROR_HANDLER = throwable -> {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println(System.currentTimeMillis() + " Exception:");
                throwable.printStackTrace(System.err);
            }
            if (throwable instanceof DriverTimeoutException) {
                System.err.printf("%n***%n*** Media Driver timeout - is it running? exiting client...%n***%n", new Object[0]);
                Thread t = new Thread(() -> Runtime.getRuntime().exit(-1));
                t.setName("runtime-exit-runner");
                t.setDaemon(true);
                t.start();
            }
        };
        public static final int MAX_CLIENT_NAME_LENGTH = 100;

        public static long idleSleepDurationNs() {
            return SystemUtil.getDurationInNanos(IDLE_SLEEP_DURATION_PROP_NAME, IDLE_SLEEP_DEFAULT_NS);
        }

        public static long resourceLingerDurationNs() {
            return SystemUtil.getDurationInNanos(RESOURCE_LINGER_DURATION_PROP_NAME, RESOURCE_LINGER_DURATION_DEFAULT_NS);
        }

        public static long closeLingerDurationNs() {
            return SystemUtil.getDurationInNanos(CLOSE_LINGER_DURATION_PROP_NAME, 0L);
        }

        public static boolean preTouchMappedMemory() {
            String value = System.getProperty(PRE_TOUCH_MAPPED_MEMORY_PROP_NAME);
            if (null != value) {
                return Boolean.parseBoolean(value);
            }
            return false;
        }

        public static String clientName() {
            return SystemUtil.getProperty(CLIENT_NAME_PROP_NAME, "");
        }
    }
}

