/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Catalog;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import org.agrona.concurrent.UnsafeBuffer;

class UpdateChannelSession
implements Session {
    private final long correlationId;
    private final long recordingId;
    private final String originalChannel;
    private final String strippedChannel;
    private final Catalog catalog;
    private final ControlSession controlSession;
    private final UnsafeBuffer descriptorBuffer;
    private final RecordingDescriptorDecoder recordingDescriptorDecoder = new RecordingDescriptorDecoder();
    private boolean isDone;

    UpdateChannelSession(long correlationId, long recordingId, String originalChannel, String strippedChannel, Catalog catalog, ControlSession controlSession, UnsafeBuffer descriptorBuffer) {
        this.correlationId = correlationId;
        this.recordingId = recordingId;
        this.originalChannel = originalChannel;
        this.strippedChannel = strippedChannel;
        this.catalog = catalog;
        this.controlSession = controlSession;
        this.descriptorBuffer = descriptorBuffer;
    }

    @Override
    public void abort(String reason) {
        this.isDone = true;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public int doWork() {
        if (this.isDone) {
            return 0;
        }
        if (this.catalog.wrapDescriptor(this.recordingId, this.descriptorBuffer)) {
            this.recordingDescriptorDecoder.wrap(this.descriptorBuffer, 32, 80, 13);
            long startPosition = this.recordingDescriptorDecoder.startPosition();
            long stopPosition = this.recordingDescriptorDecoder.stopPosition();
            long startTimestamp = this.recordingDescriptorDecoder.startTimestamp();
            long stopTimestamp = this.recordingDescriptorDecoder.stopTimestamp();
            int imageInitialTermId = this.recordingDescriptorDecoder.initialTermId();
            int segmentFileLength = this.recordingDescriptorDecoder.segmentFileLength();
            int termBufferLength = this.recordingDescriptorDecoder.termBufferLength();
            int mtuLength = this.recordingDescriptorDecoder.mtuLength();
            int sessionId = this.recordingDescriptorDecoder.sessionId();
            int streamId = this.recordingDescriptorDecoder.streamId();
            this.recordingDescriptorDecoder.skipStrippedChannel();
            this.recordingDescriptorDecoder.skipOriginalChannel();
            String sourceIdentity = this.recordingDescriptorDecoder.sourceIdentity();
            this.catalog.replaceRecording(this.recordingId, startPosition, stopPosition, startTimestamp, stopTimestamp, imageInitialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, this.strippedChannel, this.originalChannel, sourceIdentity);
            this.controlSession.sendOkResponse(this.correlationId);
        } else {
            this.controlSession.sendRecordingUnknown(this.correlationId, this.recordingId);
        }
        this.isDone = true;
        return 1;
    }

    @Override
    public long sessionId() {
        return this.correlationId;
    }

    @Override
    public void close() {
        this.controlSession.activeListing(null);
    }
}

