/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.BooleanType;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.MetaAttribute;
import io.aeron.archive.codecs.SourceLocation;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class ExtendRecordingRequest2Decoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 64;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 13;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ExtendRecordingRequest2Decoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 64;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 13;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ExtendRecordingRequest2Decoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ExtendRecordingRequest2Decoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (64 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ExtendRecordingRequest2Decoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long controlSessionId() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public static int recordingIdId() {
        return 3;
    }

    public static int recordingIdSinceVersion() {
        return 0;
    }

    public static int recordingIdEncodingOffset() {
        return 16;
    }

    public static int recordingIdEncodingLength() {
        return 8;
    }

    public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long recordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long recordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long recordingId() {
        return this.buffer.getLong(this.offset + 16, BYTE_ORDER);
    }

    public static int streamIdId() {
        return 4;
    }

    public static int streamIdSinceVersion() {
        return 0;
    }

    public static int streamIdEncodingOffset() {
        return 24;
    }

    public static int streamIdEncodingLength() {
        return 4;
    }

    public static String streamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int streamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int streamIdMinValue() {
        return -2147483647;
    }

    public static int streamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 24, BYTE_ORDER);
    }

    public static int sourceLocationId() {
        return 5;
    }

    public static int sourceLocationSinceVersion() {
        return 0;
    }

    public static int sourceLocationEncodingOffset() {
        return 28;
    }

    public static int sourceLocationEncodingLength() {
        return 4;
    }

    public static String sourceLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int sourceLocationRaw() {
        return this.buffer.getInt(this.offset + 28, BYTE_ORDER);
    }

    public SourceLocation sourceLocation() {
        return SourceLocation.get(this.buffer.getInt(this.offset + 28, BYTE_ORDER));
    }

    public static int autoStopId() {
        return 6;
    }

    public static int autoStopSinceVersion() {
        return 0;
    }

    public static int autoStopEncodingOffset() {
        return 32;
    }

    public static int autoStopEncodingLength() {
        return 4;
    }

    public static String autoStopMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int autoStopRaw() {
        return this.buffer.getInt(this.offset + 32, BYTE_ORDER);
    }

    public BooleanType autoStop() {
        return BooleanType.get(this.buffer.getInt(this.offset + 32, BYTE_ORDER));
    }

    public static int channelId() {
        return 7;
    }

    public static int channelSinceVersion() {
        return 0;
    }

    public static String channelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String channelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int channelHeaderLength() {
        return 4;
    }

    public int channelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String channel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ExtendRecordingRequest2Decoder decoder = new ExtendRecordingRequest2Decoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ExtendRecordingRequest2](sbeTemplateId=");
        builder.append(64);
        builder.append("|sbeSchemaId=");
        builder.append(101);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 13) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(13);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 36) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(36);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("recordingId=");
        builder.append(this.recordingId());
        builder.append('|');
        builder.append("streamId=");
        builder.append(this.streamId());
        builder.append('|');
        builder.append("sourceLocation=");
        builder.append((Object)this.sourceLocation());
        builder.append('|');
        builder.append("autoStop=");
        builder.append((Object)this.autoStop());
        builder.append('|');
        builder.append("channel=");
        builder.append('\'');
        this.getChannel(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public ExtendRecordingRequest2Decoder sbeSkip() {
        this.sbeRewind();
        this.skipChannel();
        return this;
    }
}

