/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.Archive;
import io.aeron.cluster.ConsensusModule;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.status.SystemCounterDescriptor;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.SystemUtil;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.status.AtomicCounter;

public class ClusteredMediaDriver
implements AutoCloseable {
    private final MediaDriver driver;
    private final Archive archive;
    private final ConsensusModule consensusModule;

    ClusteredMediaDriver(MediaDriver driver, Archive archive, ConsensusModule consensusModule) {
        this.driver = driver;
        this.archive = archive;
        this.consensusModule = consensusModule;
    }

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles(args);
        try (ShutdownSignalBarrier barrier = new ShutdownSignalBarrier();
             ClusteredMediaDriver ignore = ClusteredMediaDriver.launch(new MediaDriver.Context().terminationHook(barrier::signalAll), new Archive.Context(), new ConsensusModule.Context().terminationHook(barrier::signalAll));){
            barrier.await();
            System.out.println("Shutdown ClusteredMediaDriver...");
        }
    }

    public static ClusteredMediaDriver launch() {
        return ClusteredMediaDriver.launch(new MediaDriver.Context(), new Archive.Context(), new ConsensusModule.Context());
    }

    public static ClusteredMediaDriver launch(MediaDriver.Context driverCtx, Archive.Context archiveCtx, ConsensusModule.Context consensusModuleCtx) {
        MediaDriver driver = null;
        Archive archive = null;
        ConsensusModule consensusModule = null;
        try {
            driver = MediaDriver.launch(driverCtx);
            int errorCounterId = SystemCounterDescriptor.ERRORS.id();
            AtomicCounter errorCounter = null != archiveCtx.errorCounter() ? archiveCtx.errorCounter() : new AtomicCounter(driverCtx.countersValuesBuffer(), errorCounterId);
            ErrorHandler errorHandler = null != archiveCtx.errorHandler() ? archiveCtx.errorHandler() : driverCtx.errorHandler();
            archive = Archive.launch(archiveCtx.mediaDriverAgentInvoker(driver.sharedAgentInvoker()).aeronDirectoryName(driver.aeronDirectoryName()).errorHandler(errorHandler).errorCounter(errorCounter));
            consensusModule = ConsensusModule.launch(consensusModuleCtx.aeronDirectoryName(driverCtx.aeronDirectoryName()));
            return new ClusteredMediaDriver(driver, archive, consensusModule);
        }
        catch (Exception ex) {
            CloseHelper.quietCloseAll(consensusModule, archive, driver);
            throw ex;
        }
    }

    public MediaDriver mediaDriver() {
        return this.driver;
    }

    public Archive archive() {
        return this.archive;
    }

    public ConsensusModule consensusModule() {
        return this.consensusModule;
    }

    @Override
    public void close() {
        CloseHelper.closeAll(this.consensusModule, this.archive, this.driver);
    }
}

