/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Publication;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.client.ClusterEvent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.ClusterMembersExtendedResponseEncoder;
import io.aeron.cluster.codecs.ClusterMembersResponseEncoder;
import io.aeron.cluster.codecs.JoinLogEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.RequestServiceAckEncoder;
import io.aeron.cluster.codecs.ServiceTerminationPositionEncoder;
import io.aeron.cluster.service.Cluster;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;

final class ServiceProxy
implements AutoCloseable {
    private static final int SEND_ATTEMPTS = 5;
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final JoinLogEncoder joinLogEncoder = new JoinLogEncoder();
    private final ClusterMembersResponseEncoder clusterMembersResponseEncoder = new ClusterMembersResponseEncoder();
    private final ServiceTerminationPositionEncoder serviceTerminationPositionEncoder = new ServiceTerminationPositionEncoder();
    private final ClusterMembersExtendedResponseEncoder clusterMembersExtendedResponseEncoder = new ClusterMembersExtendedResponseEncoder();
    private final RequestServiceAckEncoder requestServiceAckEncoder = new RequestServiceAckEncoder();
    private final ExpandableArrayBuffer expandableArrayBuffer = new ExpandableArrayBuffer();
    private final Publication publication;

    ServiceProxy(Publication publication) {
        this.publication = publication;
    }

    @Override
    public void close() {
        CloseHelper.close(this.publication);
    }

    void joinLog(long logPosition, long maxLogPosition, int memberId, int logSessionId, int logStreamId, boolean isStartup, Cluster.Role role, String channel) {
        long position;
        int length = 44 + JoinLogEncoder.logChannelHeaderLength() + channel.length();
        int attempts = 5;
        do {
            if ((position = this.publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.joinLogEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition).maxLogPosition(maxLogPosition).memberId(memberId).logSessionId(logSessionId).logStreamId(logStreamId).isStartup(isStartup ? BooleanType.TRUE : BooleanType.FALSE).role(role.code()).logChannel(channel);
                this.bufferClaim.commit();
                return;
            }
            ServiceProxy.checkResult(position, this.publication);
            if (-2L != position) continue;
            Thread.yield();
        } while (--attempts > 0);
        throw new ClusterException("failed to send join log request: " + Publication.errorString(position));
    }

    void clusterMembersResponse(long correlationId, int leaderMemberId, String activeMembers) {
        long result;
        String passiveFollowers = "";
        int length = 20 + ClusterMembersResponseEncoder.activeMembersHeaderLength() + activeMembers.length() + ClusterMembersResponseEncoder.passiveFollowersHeaderLength() + "".length();
        int attempts = 5;
        do {
            if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.clusterMembersResponseEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).leaderMemberId(leaderMemberId).activeMembers(activeMembers).passiveFollowers("");
                this.bufferClaim.commit();
                return;
            }
            if (-2L != result) continue;
            Thread.yield();
        } while (--attempts > 0);
        throw new ClusterException("failed to send cluster members response: result=" + result);
    }

    void clusterMembersExtendedResponse(long correlationId, long currentTimeNs, int leaderMemberId, int memberId, ClusterMember[] activeMembers) {
        long result;
        this.clusterMembersExtendedResponseEncoder.wrapAndApplyHeader(this.expandableArrayBuffer, 0, this.messageHeaderEncoder).correlationId(correlationId).currentTimeNs(currentTimeNs).leaderMemberId(leaderMemberId).memberId(memberId);
        ClusterMembersExtendedResponseEncoder.ActiveMembersEncoder activeMembersEncoder = this.clusterMembersExtendedResponseEncoder.activeMembersCount(activeMembers.length);
        for (ClusterMember member : activeMembers) {
            activeMembersEncoder.next().leadershipTermId(member.leadershipTermId()).logPosition(member.logPosition()).timeOfLastAppendNs(member.timeOfLastAppendPositionNs()).memberId(member.id()).ingressEndpoint(member.ingressEndpoint()).consensusEndpoint(member.consensusEndpoint()).logEndpoint(member.logEndpoint()).catchupEndpoint(member.catchupEndpoint()).archiveEndpoint(member.archiveEndpoint());
        }
        this.clusterMembersExtendedResponseEncoder.passiveMembersCount(0);
        int length = 8 + this.clusterMembersExtendedResponseEncoder.encodedLength();
        int attempts = 5;
        do {
            if ((result = this.publication.offer(this.expandableArrayBuffer, 0, length, null)) > 0L) {
                return;
            }
            if (-2L != result) continue;
            Thread.yield();
        } while (--attempts > 0);
        throw new ClusterException("failed to send cluster members extended response: result=" + result);
    }

    void terminationPosition(long logPosition, ErrorHandler errorHandler) {
        if (!this.publication.isClosed()) {
            long result;
            int length = 16;
            int attempts = 5;
            do {
                if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                    this.serviceTerminationPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition);
                    this.bufferClaim.commit();
                    return;
                }
                if (-2L != result) continue;
                Thread.yield();
            } while (--attempts > 0);
            errorHandler.onError(new ClusterEvent("failed to send service termination position: result=" + result, AeronException.Category.WARN));
        }
    }

    void requestServiceAck(long logPosition) {
        long result;
        int length = 16;
        int attempts = 5;
        do {
            if ((result = this.publication.tryClaim(16, this.bufferClaim)) > 0L) {
                this.requestServiceAckEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logPosition(logPosition);
                this.bufferClaim.commit();
                return;
            }
            if (-2L != result) continue;
            Thread.yield();
        } while (--attempts > 0);
        throw new ClusterException("failed to send request for service ack: result=" + Publication.errorString(result));
    }

    private static void checkResult(long position, Publication publication) {
        if (-1L == position) {
            throw new ClusterException("publication is not connected");
        }
        if (-4L == position) {
            throw new ClusterException("publication is closed");
        }
        if (-5L == position) {
            throw new ClusterException("publication at max position: term-length=" + publication.termBufferLength());
        }
    }
}

