/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.protocol.ResolutionEntryFlyweight;
import java.util.ArrayList;
import java.util.Arrays;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.status.AtomicCounter;

final class DriverNameResolverCache {
    private final ArrayList<CacheEntry> entries = new ArrayList();
    private final long timeoutMs;
    private final Iterator iterator = new Iterator();

    DriverNameResolverCache(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    CacheEntry lookup(String name, byte type) {
        for (CacheEntry entry : this.entries) {
            if (type != entry.type || !DriverNameResolverCache.fullLengthMatch(entry.name, name)) continue;
            return entry;
        }
        return null;
    }

    void addOrUpdateEntry(byte[] name, int nameLength, long nowMs, byte type, byte[] address, int port, AtomicCounter cacheEntriesCounter) {
        CacheEntry entry = this.findEntryIndexByNameAndType(name, nameLength, type);
        int addressLength = ResolutionEntryFlyweight.addressLength(type);
        if (null == entry) {
            entry = new CacheEntry(Arrays.copyOf(name, nameLength), type, nowMs, nowMs + this.timeoutMs, Arrays.copyOf(address, addressLength), port);
            this.entries.add(entry);
            cacheEntriesCounter.setRelease(this.entries.size());
        } else {
            entry.timeOfLastActivityMs = nowMs;
            entry.deadlineMs = nowMs + this.timeoutMs;
            if (port != entry.port || !DriverNameResolverCache.fullLengthMatch(entry.address, address, addressLength)) {
                entry.address = Arrays.copyOf(address, addressLength);
                entry.port = port;
            }
        }
    }

    int timeoutOldEntries(long nowMs, AtomicCounter cacheEntriesCounter) {
        int lastIndex;
        int workCount = 0;
        ArrayList<CacheEntry> listOfEntries = this.entries;
        for (int i = lastIndex = listOfEntries.size() - 1; i >= 0; --i) {
            CacheEntry entry = listOfEntries.get(i);
            if (entry.deadlineMs - nowMs >= 0L) continue;
            ArrayListUtil.fastUnorderedRemove(listOfEntries, i, lastIndex--);
            cacheEntriesCounter.setRelease(listOfEntries.size());
            ++workCount;
        }
        return workCount;
    }

    Iterator resetIterator() {
        this.iterator.cache = this;
        this.iterator.index = -1;
        return this.iterator;
    }

    static boolean fullLengthMatch(byte[] expected, byte[] actual, int actualLength) {
        return actualLength == expected.length && Arrays.equals(expected, 0, actualLength, actual, 0, actualLength);
    }

    static boolean fullLengthMatch(byte[] expected, String actual) {
        int length = actual.length();
        if (length != expected.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (expected[i] == actual.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private CacheEntry findEntryIndexByNameAndType(byte[] name, int nameLength, byte type) {
        for (CacheEntry entry : this.entries) {
            if (type != entry.type || !DriverNameResolverCache.fullLengthMatch(entry.name, name, nameLength)) continue;
            return entry;
        }
        return null;
    }

    static final class Iterator {
        int index = -1;
        DriverNameResolverCache cache;

        Iterator() {
        }

        boolean hasNext() {
            return this.index + 1 < this.cache.entries.size();
        }

        CacheEntry next() {
            return this.cache.entries.get(++this.index);
        }

        void rewindNext() {
            --this.index;
        }
    }

    static final class CacheEntry {
        long deadlineMs;
        long timeOfLastActivityMs;
        int port;
        final byte type;
        final byte[] name;
        byte[] address;

        CacheEntry(byte[] name, byte type, long timeOfLastActivityMs, long deadlineMs, byte[] address, int port) {
            this.name = name;
            this.type = type;
            this.timeOfLastActivityMs = timeOfLastActivityMs;
            this.deadlineMs = deadlineMs;
            this.address = address;
            this.port = port;
        }
    }
}

