/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.ErrorFlyweight;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.ResponseSetupFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.function.Consumer;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class ControlTransportPoller
extends UdpTransportPoller {
    private static final SendChannelEndpoint[] EMPTY_TRANSPORTS = new SendChannelEndpoint[0];
    private final ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned(65504, 64);
    private final UnsafeBuffer unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
    private final NakFlyweight nakMessage = new NakFlyweight(this.unsafeBuffer);
    private final StatusMessageFlyweight statusMessage = new StatusMessageFlyweight(this.unsafeBuffer);
    private final RttMeasurementFlyweight rttMeasurement = new RttMeasurementFlyweight(this.unsafeBuffer);
    private final ResponseSetupFlyweight responseSetup = new ResponseSetupFlyweight(this.unsafeBuffer);
    private final ErrorFlyweight error = new ErrorFlyweight(this.unsafeBuffer);
    private final DriverConductorProxy conductorProxy;
    private final Consumer<SelectionKey> selectorPoller = selectionKey -> this.poll((SendChannelEndpoint)selectionKey.attachment());
    private SendChannelEndpoint[] transports = EMPTY_TRANSPORTS;
    private int totalBytesReceived;

    public ControlTransportPoller(ErrorHandler errorHandler, DriverConductorProxy conductorProxy) {
        super(errorHandler);
        this.conductorProxy = conductorProxy;
    }

    @Override
    public void close() {
        CloseHelper.closeAll(this.errorHandler, (AutoCloseable[])this.transports);
        super.close();
    }

    @Override
    public int pollTransports() {
        this.totalBytesReceived = 0;
        if (this.transports.length <= ITERATION_THRESHOLD) {
            for (SendChannelEndpoint transport : this.transports) {
                this.poll(transport);
            }
        } else {
            try {
                this.selector.selectNow(this.selectorPoller);
            }
            catch (IOException ex) {
                this.errorHandler.onError(ex);
            }
        }
        return this.totalBytesReceived;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport transport) {
        return this.registerChannelForRead((SendChannelEndpoint)transport);
    }

    private SelectionKey registerChannelForRead(SendChannelEndpoint transport) {
        SelectionKey key = null;
        try {
            key = transport.receiveDatagramChannel().register(this.selector, 1, transport);
            this.transports = ArrayUtil.add(this.transports, transport);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return key;
    }

    @Override
    public void cancelRead(UdpChannelTransport transport) {
        this.transports = ArrayUtil.remove(this.transports, (SendChannelEndpoint)transport);
    }

    public void checkForReResolutions(long nowNs, DriverConductorProxy conductorProxy) {
        for (SendChannelEndpoint transport : this.transports) {
            transport.checkForReResolution(nowNs, conductorProxy);
        }
    }

    public String toString() {
        return "ControlTransportPoller{}";
    }

    private void poll(SendChannelEndpoint channelEndpoint) {
        try {
            this.receive(channelEndpoint);
        }
        catch (Exception ex) {
            this.errorHandler.onError(ex);
        }
    }

    private void receive(SendChannelEndpoint channelEndpoint) {
        InetSocketAddress srcAddress = channelEndpoint.receive(this.byteBuffer);
        if (null != srcAddress) {
            int length = this.byteBuffer.position();
            this.totalBytesReceived += length;
            if (channelEndpoint.isValidFrame(this.unsafeBuffer, length)) {
                channelEndpoint.receiveHook(this.unsafeBuffer, length, srcAddress);
                int frameType = FrameDescriptor.frameType(this.unsafeBuffer, 0);
                if (2 == frameType) {
                    channelEndpoint.onNakMessage(this.nakMessage, this.unsafeBuffer, length, srcAddress);
                } else if (3 == frameType) {
                    channelEndpoint.onStatusMessage(this.statusMessage, this.unsafeBuffer, length, srcAddress, this.conductorProxy);
                } else if (4 == frameType) {
                    channelEndpoint.onError(this.error, this.unsafeBuffer, length, srcAddress, this.conductorProxy);
                } else if (6 == frameType) {
                    channelEndpoint.onRttMeasurement(this.rttMeasurement, this.unsafeBuffer, length, srcAddress);
                } else if (11 == frameType) {
                    channelEndpoint.onResponseSetup(this.responseSetup, this.unsafeBuffer, length, srcAddress, this.conductorProxy);
                }
            }
        }
    }
}

