/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.media.PortManager;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.AeronEvent;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.FrameDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public abstract class UdpChannelTransport
implements AutoCloseable {
    protected final MediaDriver.Context context;
    protected final ErrorHandler errorHandler;
    protected final UdpChannel udpChannel;
    protected DatagramChannel sendDatagramChannel;
    protected DatagramChannel receiveDatagramChannel;
    protected InetSocketAddress connectAddress;
    protected SelectionKey selectionKey;
    private UdpTransportPoller transportPoller;
    private InetSocketAddress bindAddress;
    private final InetSocketAddress endPointAddress;
    private final AtomicCounter invalidPackets;
    private final PortManager portManager;
    protected boolean isClosed = false;
    private int multicastTtl = 0;
    private final int socketSndbufLength;
    private final int socketRcvbufLength;

    protected UdpChannelTransport(UdpChannel udpChannel, InetSocketAddress endPointAddress, InetSocketAddress bindAddress, InetSocketAddress connectAddress, PortManager portManager, MediaDriver.Context context, int socketRcvbufLength, int socketSndbufLength) {
        this.context = context;
        this.udpChannel = udpChannel;
        this.errorHandler = context.countedErrorHandler();
        this.portManager = portManager;
        this.endPointAddress = endPointAddress;
        this.bindAddress = bindAddress;
        this.connectAddress = connectAddress;
        this.invalidPackets = context.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS);
        this.socketRcvbufLength = socketRcvbufLength;
        this.socketSndbufLength = socketSndbufLength;
    }

    protected UdpChannelTransport(UdpChannel udpChannel, InetSocketAddress endPointAddress, InetSocketAddress bindAddress, InetSocketAddress connectAddress, PortManager portManager, MediaDriver.Context context) {
        this(udpChannel, endPointAddress, bindAddress, connectAddress, portManager, context, udpChannel.socketRcvbufLengthOrDefault(context.socketRcvbufLength()), udpChannel.socketSndbufLengthOrDefault(context.socketSndbufLength()));
    }

    @Deprecated(forRemoval=true, since="1.46.6")
    public static void sendError(int bytesToSend, IOException ex, InetSocketAddress destination) {
        throw new AeronException("failed to send " + bytesToSend + " byte packet to " + String.valueOf(destination), ex, AeronException.Category.WARN);
    }

    public static void onSendError(IOException ex, InetSocketAddress destination, ErrorHandler errorHandler) {
        errorHandler.onError(new AeronEvent("failed to send datagram to " + String.valueOf(destination) + ", cause: " + String.valueOf(ex), AeronException.Category.WARN));
    }

    public void openDatagramChannel(AtomicCounter statusIndicator) {
        try {
            this.receiveDatagramChannel = this.sendDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
            if (this.udpChannel.isMulticast()) {
                if (null != this.connectAddress) {
                    this.receiveDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
                }
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                this.receiveDatagramChannel.bind(new InetSocketAddress(this.endPointAddress.getPort()));
                this.receiveDatagramChannel.join(this.endPointAddress.getAddress(), this.udpChannel.localInterface());
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, this.udpChannel.localInterface());
                if (this.udpChannel.hasMulticastTtl()) {
                    this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.udpChannel.multicastTtl());
                    this.multicastTtl = this.sendDatagramChannel.getOption(StandardSocketOptions.IP_MULTICAST_TTL);
                } else if (this.context.socketMulticastTtl() != 0) {
                    this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.context.socketMulticastTtl());
                    this.multicastTtl = this.sendDatagramChannel.getOption(StandardSocketOptions.IP_MULTICAST_TTL);
                }
            } else {
                this.bindAddress = this.portManager.getManagedPort(this.udpChannel, this.bindAddress);
                this.sendDatagramChannel.bind(this.bindAddress);
            }
            if (null != this.connectAddress) {
                this.sendDatagramChannel.connect(this.connectAddress);
            }
            if (0 != this.socketSndbufLength()) {
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.socketSndbufLength());
            }
            if (0 != this.socketRcvbufLength()) {
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.socketRcvbufLength());
            }
            this.sendDatagramChannel.configureBlocking(false);
            this.receiveDatagramChannel.configureBlocking(false);
        }
        catch (IOException ex) {
            if (null != statusIndicator) {
                statusIndicator.setRelease(-1L);
            }
            CloseHelper.quietClose(this.sendDatagramChannel);
            if (this.receiveDatagramChannel != this.sendDatagramChannel) {
                CloseHelper.quietClose(this.receiveDatagramChannel);
            }
            this.sendDatagramChannel = null;
            this.receiveDatagramChannel = null;
            String message = "channel error - " + ex.getMessage() + " (at " + ex.getStackTrace()[0].toString() + "): " + this.udpChannel.originalUriString();
            throw new AeronException(message, ex);
        }
    }

    public void registerForRead(UdpTransportPoller transportPoller) {
        this.transportPoller = transportPoller;
        this.selectionKey = transportPoller.registerForRead(this);
    }

    public UdpChannel udpChannel() {
        return this.udpChannel;
    }

    public DatagramChannel receiveDatagramChannel() {
        return this.receiveDatagramChannel;
    }

    public int multicastTtl() {
        return this.multicastTtl;
    }

    public String bindAddressAndPort() {
        try {
            InetSocketAddress localAddress = (InetSocketAddress)this.receiveDatagramChannel.getLocalAddress();
            if (null != localAddress) {
                return NetworkUtil.formatAddressAndPort(localAddress.getAddress(), localAddress.getPort());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (null != this.selectionKey) {
                this.selectionKey.cancel();
            }
            if (null != this.transportPoller) {
                this.transportPoller.cancelRead(this);
                this.transportPoller.selectNowWithoutProcessing();
            }
            CloseHelper.close(this.errorHandler, this.sendDatagramChannel);
            CloseHelper.close(this.errorHandler, this.receiveDatagramChannel);
            if (null != this.transportPoller) {
                this.transportPoller.selectNowWithoutProcessing();
            }
            this.portManager.freeManagedPort(this.bindAddress);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isMulticast() {
        return this.udpChannel.isMulticast();
    }

    public boolean isValidFrame(UnsafeBuffer buffer, int length) {
        if (length >= 8 && FrameDescriptor.frameVersion(buffer, 0) == 0) {
            return true;
        }
        this.invalidPackets.increment();
        return false;
    }

    public void sendHook(ByteBuffer buffer, InetSocketAddress address) {
    }

    public void receiveHook(UnsafeBuffer buffer, int length, InetSocketAddress address) {
    }

    public void resendHook(int sessionId, int streamId, int termId, int termOffset, int length) {
    }

    public InetSocketAddress receive(ByteBuffer buffer) {
        buffer.clear();
        InetSocketAddress address = null;
        try {
            if (this.receiveDatagramChannel.isOpen()) {
                address = (InetSocketAddress)this.receiveDatagramChannel.receive(buffer);
            }
        }
        catch (PortUnreachableException portUnreachableException) {
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return address;
    }

    public void updateEndpoint(InetSocketAddress newAddress, AtomicCounter statusIndicator) {
        try {
            if (null != this.sendDatagramChannel) {
                this.sendDatagramChannel.disconnect();
                this.sendDatagramChannel.connect(newAddress);
                this.connectAddress = newAddress;
                if (null != statusIndicator) {
                    statusIndicator.setRelease(1L);
                }
            }
        }
        catch (Exception ex) {
            if (null != statusIndicator) {
                statusIndicator.setRelease(-1L);
            }
            String message = "re-resolve endpoint channel error - " + ex.getMessage() + " (at " + ex.getStackTrace()[0].toString() + "): " + this.udpChannel.originalUriString();
            throw new AeronException(message, ex);
        }
    }

    public int socketSndbufLength() {
        return this.socketSndbufLength;
    }

    public int socketRcvbufLength() {
        return this.socketRcvbufLength;
    }
}

