/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.PortManager;
import io.aeron.driver.media.UdpChannel;
import java.net.BindException;
import java.net.InetSocketAddress;
import org.agrona.collections.IntHashSet;

public class WildcardPortManager
implements PortManager {
    public static final int[] EMPTY_PORT_RANGE = new int[2];
    final IntHashSet portSet = new IntHashSet();
    final int highPort;
    final int lowPort;
    final boolean isOsWildcard;
    final boolean isSender;
    int nextPort;

    public WildcardPortManager(int[] portRange, boolean isSender) {
        this.lowPort = portRange[0];
        this.highPort = portRange[1];
        this.isOsWildcard = this.lowPort == this.highPort && 0 == this.lowPort;
        this.nextPort = this.lowPort;
        this.isSender = isSender;
    }

    @Override
    public InetSocketAddress getManagedPort(UdpChannel udpChannel, InetSocketAddress bindAddress) throws BindException {
        InetSocketAddress address = bindAddress;
        if (bindAddress.getPort() != 0) {
            this.portSet.add(bindAddress.getPort());
        } else if (!(this.isOsWildcard || this.isSender && !udpChannel.hasExplicitControl())) {
            address = new InetSocketAddress(bindAddress.getAddress(), this.allocateOpenPort());
        }
        return address;
    }

    @Override
    public void freeManagedPort(InetSocketAddress bindAddress) {
        if (bindAddress.getPort() != 0) {
            this.portSet.remove(bindAddress.getPort());
        }
    }

    public static int[] parsePortRange(String value) {
        if (null == value || value.isEmpty()) {
            return EMPTY_PORT_RANGE;
        }
        String[] ports = value.split(" +");
        if (ports.length != 2) {
            throw new IllegalArgumentException("port range \"" + value + "\" incorrect format");
        }
        int[] portRange = new int[2];
        try {
            portRange[0] = Integer.parseUnsignedInt(ports[0]);
            portRange[1] = Integer.parseUnsignedInt(ports[1]);
            if (portRange[0] > 65535 || portRange[1] > 65535) {
                throw new NumberFormatException(value + ":port must be an integer value between 0 and 65535");
            }
            if (portRange[0] > portRange[1]) {
                throw new NumberFormatException(value + ":low port value must be lower than high port value");
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("invalid port value " + value, ex);
        }
        return portRange;
    }

    private int findOpenPort() {
        int i;
        for (i = this.nextPort; i <= this.highPort; ++i) {
            if (this.portSet.contains(i)) continue;
            return i;
        }
        for (i = this.lowPort; i < this.nextPort; ++i) {
            if (this.portSet.contains(i)) continue;
            return i;
        }
        return 0;
    }

    private int allocateOpenPort() throws BindException {
        int port = this.findOpenPort();
        if (0 == port) {
            throw new BindException("no available ports in range " + this.lowPort + " " + this.highPort);
        }
        this.nextPort = port + 1;
        if (this.nextPort > this.highPort) {
            this.nextPort = this.lowPort;
        }
        this.portSet.add(port);
        return port;
    }
}

