/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.BufferUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class DataHeaderFlyweight
extends HeaderFlyweight {
    public static final int HEADER_LENGTH = 32;
    public static final short BEGIN_FLAG = 128;
    public static final short END_FLAG = 64;
    public static final short BEGIN_AND_END_FLAGS = 192;
    public static final short EOS_FLAG = 32;
    public static final short BEGIN_END_AND_EOS_FLAGS = 224;
    public static final short REVOKED_FLAG = 16;
    public static final short BEGIN_END_EOS_AND_REVOKED_FLAGS = 240;
    public static final long DEFAULT_RESERVE_VALUE = 0L;
    public static final int TERM_OFFSET_FIELD_OFFSET = 8;
    public static final int SESSION_ID_FIELD_OFFSET = 12;
    public static final int STREAM_ID_FIELD_OFFSET = 16;
    public static final int TERM_ID_FIELD_OFFSET = 20;
    public static final int RESERVED_VALUE_OFFSET = 24;
    public static final int DATA_OFFSET = 32;

    public DataHeaderFlyweight() {
    }

    public DataHeaderFlyweight(UnsafeBuffer buffer) {
        super(buffer);
    }

    public DataHeaderFlyweight(ByteBuffer buffer) {
        super(buffer);
    }

    public static int fragmentLength(UnsafeBuffer termBuffer, int frameOffset) {
        return termBuffer.getInt(frameOffset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static boolean isHeartbeat(UnsafeBuffer packet, int length) {
        return length == 32 && packet.getInt(0) == 0;
    }

    public static boolean isEndOfStream(UnsafeBuffer packet) {
        return 0 != (packet.getByte(5) & 0x20);
    }

    public static boolean isRevoked(UnsafeBuffer packet) {
        return 0 != (packet.getByte(5) & 0x10);
    }

    public int sessionId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionId(UnsafeBuffer termBuffer, int frameOffset) {
        return termBuffer.getInt(frameOffset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight sessionId(int sessionId) {
        this.putInt(12, sessionId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int streamId(UnsafeBuffer termBuffer, int frameOffset) {
        return termBuffer.getInt(frameOffset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight streamId(int streamId) {
        this.putInt(16, streamId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int termId() {
        return this.getInt(20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int termId(UnsafeBuffer termBuffer, int frameOffset) {
        return termBuffer.getInt(frameOffset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight termId(int termId) {
        this.putInt(20, termId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int termOffset() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int termOffset(UnsafeBuffer termBuffer, int frameOffset) {
        return termBuffer.getInt(frameOffset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight termOffset(int termOffset) {
        this.putInt(8, termOffset, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long reservedValue() {
        return this.getLong(24, ByteOrder.LITTLE_ENDIAN);
    }

    public static long reservedValue(UnsafeBuffer termBuffer, int frameOffset) {
        return termBuffer.getLong(frameOffset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public DataHeaderFlyweight reservedValue(long reservedValue) {
        this.putLong(24, reservedValue, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int dataOffset() {
        return 32;
    }

    public static UnsafeBuffer createDefaultHeader(int sessionId, int streamId, int termId) {
        UnsafeBuffer buffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned(32, 64));
        buffer.putByte(4, (byte)0);
        buffer.putByte(5, (byte)-64);
        buffer.putShort(6, (short)1, ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(12, sessionId, ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(16, streamId, ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(20, termId, ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(24, 0L);
        return buffer;
    }

    @Override
    public String toString() {
        return "DATA Header{frame-length=" + this.frameLength() + " version=" + this.version() + " flags=" + String.valueOf(DataHeaderFlyweight.flagsToChars(this.flags())) + " type=" + this.headerType() + " term-offset=" + this.termOffset() + " session-id=" + this.sessionId() + " stream-id=" + this.streamId() + " term-id=" + this.termId() + " reserved-value=" + this.reservedValue() + "}";
    }
}

