/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.ShutdownSignalBarrier;

public class SimpleSubscriber {
    public static void main(String[] args) {
        int fragmentLimitCount = 10;
        String channel = "aeron:udp?endpoint=localhost:40123";
        int streamId = 10;
        System.out.println("Subscribing to aeron:udp?endpoint=localhost:40123 on stream id 10");
        Aeron.Context ctx = new Aeron.Context();
        AtomicBoolean running = new AtomicBoolean(true);
        try (ShutdownSignalBarrier ignore = new ShutdownSignalBarrier(() -> running.set(false));
             Aeron aeron = Aeron.connect(ctx);
             Subscription subscription = aeron.addSubscription("aeron:udp?endpoint=localhost:40123", 10);){
            BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(100L, 10L, TimeUnit.MICROSECONDS.toNanos(1L), TimeUnit.MICROSECONDS.toNanos(100L));
            FragmentHandler fragmentHandler = (buffer, offset, length, header) -> {
                byte[] data = new byte[length];
                buffer.getBytes(offset, data);
                System.out.printf("Received message (%s) to stream %d from session %x term id %x term offset %d (%d@%d)%n", new String(data), 10, header.sessionId(), header.termId(), header.termOffset(), length, offset);
                running.set(false);
            };
            while (running.get()) {
                int fragmentsRead = subscription.poll(fragmentHandler, 10);
                idleStrategy.idle(fragmentsRead);
            }
            System.out.println("Shutting down...");
        }
    }
}

