/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.ChannelUri;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.samples.SampleConfiguration;
import io.aeron.samples.SamplesUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.ShutdownSignalBarrier;

public class ReplayedBasicSubscriber {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final int REPLAY_STREAM_ID = SampleConfiguration.STREAM_ID + 1;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;

    public static void main(String[] args) {
        System.out.println("Subscribing to " + CHANNEL + " on stream id " + STREAM_ID);
        FragmentHandler fragmentHandler = SamplesUtil.printAsciiMessage(STREAM_ID);
        AeronArchive.Context archiveCtx = new AeronArchive.Context().controlResponseStreamId(AeronArchive.Configuration.controlResponseStreamId() + 2);
        AtomicBoolean running = new AtomicBoolean(true);
        try (ShutdownSignalBarrier ignore = new ShutdownSignalBarrier(() -> running.set(false));
             AeronArchive archive = AeronArchive.connect(archiveCtx);){
            long recordingId = ReplayedBasicSubscriber.findLatestRecording(archive);
            long position = 0L;
            long length = Long.MAX_VALUE;
            long sessionId = archive.startReplay(recordingId, 0L, Long.MAX_VALUE, CHANNEL, REPLAY_STREAM_ID);
            String channel = ChannelUri.addSessionId(CHANNEL, (int)sessionId);
            try (Subscription subscription = archive.context().aeron().addSubscription(channel, REPLAY_STREAM_ID);){
                SamplesUtil.subscriberLoop(fragmentHandler, FRAGMENT_COUNT_LIMIT, running).accept(subscription);
                System.out.println("Shutting down...");
            }
        }
    }

    private static long findLatestRecording(AeronArchive archive) {
        MutableLong lastRecordingId = new MutableLong();
        RecordingDescriptorConsumer consumer = (controlSessionId, correlationId, recordingId, startTimestamp, stopTimestamp, startPosition, stopPosition, initialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, strippedChannel, originalChannel, sourceIdentity) -> lastRecordingId.set(recordingId);
        long fromRecordingId = 0L;
        int recordCount = 100;
        int foundCount = archive.listRecordingsForUri(0L, 100, CHANNEL, STREAM_ID, consumer);
        if (foundCount == 0) {
            throw new IllegalStateException("no recordings found");
        }
        return lastRecordingId.get();
    }
}

