/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.cluster;

import io.aeron.CommonContext;
import io.aeron.archive.Archive;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.service.ClusteredService;
import io.aeron.cluster.service.ClusteredServiceContainer;
import io.aeron.driver.MediaDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.NoOpLock;

public final class ClusterConfig {
    public static final int PORTS_PER_NODE = 100;
    public static final int ARCHIVE_CONTROL_PORT_OFFSET = 1;
    public static final int CLIENT_FACING_PORT_OFFSET = 2;
    public static final int MEMBER_FACING_PORT_OFFSET = 3;
    public static final int LOG_PORT_OFFSET = 4;
    public static final int TRANSFER_PORT_OFFSET = 5;
    public static final String ARCHIVE_SUB_DIR = "archive";
    public static final String CLUSTER_SUB_DIR = "cluster";
    private final int memberId;
    private final String ingressHostname;
    private final String clusterHostname;
    private final MediaDriver.Context mediaDriverContext;
    private final Archive.Context archiveContext;
    private final AeronArchive.Context aeronArchiveContext;
    private final ConsensusModule.Context consensusModuleContext;
    private final List<ClusteredServiceContainer.Context> clusteredServiceContexts;

    ClusterConfig(int memberId, String ingressHostname, String clusterHostname, MediaDriver.Context mediaDriverContext, Archive.Context archiveContext, AeronArchive.Context aeronArchiveContext, ConsensusModule.Context consensusModuleContext, List<ClusteredServiceContainer.Context> clusteredServiceContexts) {
        this.memberId = memberId;
        this.ingressHostname = ingressHostname;
        this.clusterHostname = clusterHostname;
        this.mediaDriverContext = mediaDriverContext;
        this.archiveContext = archiveContext;
        this.aeronArchiveContext = aeronArchiveContext;
        this.consensusModuleContext = consensusModuleContext;
        this.clusteredServiceContexts = clusteredServiceContexts;
    }

    public static ClusterConfig create(int startingMemberId, int memberId, List<String> ingressHostnames, List<String> clusterHostnames, int portBase, File parentDir, ClusteredService clusteredService, ClusteredService ... additionalServices) {
        if (memberId < startingMemberId || startingMemberId + ingressHostnames.size() <= memberId) {
            throw new IllegalArgumentException("memberId=" + memberId + " is invalid, should be " + startingMemberId + " <= memberId < " + startingMemberId + ingressHostnames.size());
        }
        String clusterMembers = ClusterConfig.clusterMembers(startingMemberId, ingressHostnames, clusterHostnames, portBase);
        String aeronDirName = CommonContext.getAeronDirectoryName() + "-" + memberId + "-driver";
        File baseDir = new File(parentDir, "aeron-cluster-" + memberId);
        String ingressHostname = ingressHostnames.get(memberId - startingMemberId);
        String hostname = clusterHostnames.get(memberId - startingMemberId);
        MediaDriver.Context mediaDriverContext = new MediaDriver.Context().aeronDirectoryName(aeronDirName);
        AeronArchive.Context replicationArchiveContext = new AeronArchive.Context().controlResponseChannel("aeron:udp?endpoint=" + hostname + ":0");
        Archive.Context archiveContext = new Archive.Context().aeronDirectoryName(aeronDirName).archiveDir(new File(baseDir, ARCHIVE_SUB_DIR)).controlChannel(ClusterConfig.udpChannel(memberId, hostname, portBase, 1)).archiveClientContext(replicationArchiveContext).localControlChannel("aeron:ipc?term-length=64k").replicationChannel("aeron:udp?endpoint=" + hostname + ":0").recordingEventsEnabled(false);
        AeronArchive.Context aeronArchiveContext = new AeronArchive.Context().lock(NoOpLock.INSTANCE).controlRequestChannel(archiveContext.localControlChannel()).controlRequestStreamId(archiveContext.localControlStreamId()).controlResponseChannel(archiveContext.localControlChannel()).aeronDirectoryName(aeronDirName);
        ConsensusModule.Context consensusModuleContext = new ConsensusModule.Context().clusterMemberId(memberId).clusterMembers(clusterMembers).clusterDir(new File(baseDir, CLUSTER_SUB_DIR)).archiveContext(aeronArchiveContext.clone()).serviceCount(1 + additionalServices.length).replicationChannel("aeron:udp?endpoint=" + hostname + ":0");
        ArrayList<ClusteredServiceContainer.Context> serviceContexts = new ArrayList<ClusteredServiceContainer.Context>();
        ClusteredServiceContainer.Context clusteredServiceContext = new ClusteredServiceContainer.Context().aeronDirectoryName(aeronDirName).archiveContext(aeronArchiveContext.clone()).clusterDir(new File(baseDir, CLUSTER_SUB_DIR)).clusteredService(clusteredService).serviceId(0);
        serviceContexts.add(clusteredServiceContext);
        for (int i = 0; i < additionalServices.length; ++i) {
            ClusteredServiceContainer.Context additionalServiceContext = new ClusteredServiceContainer.Context().aeronDirectoryName(aeronDirName).archiveContext(aeronArchiveContext.clone()).clusterDir(new File(baseDir, CLUSTER_SUB_DIR)).clusteredService(additionalServices[i]).serviceId(i + 1);
            serviceContexts.add(additionalServiceContext);
        }
        return new ClusterConfig(memberId, ingressHostname, hostname, mediaDriverContext, archiveContext, aeronArchiveContext, consensusModuleContext, serviceContexts);
    }

    public static ClusterConfig create(int nodeId, List<String> ingressHostnames, List<String> clusterHostnames, int portBase, ClusteredService clusteredService, ClusteredService ... additionalServices) {
        return ClusterConfig.create(0, nodeId, ingressHostnames, clusterHostnames, portBase, new File(System.getProperty("user.dir")), clusteredService, additionalServices);
    }

    public static ClusterConfig create(int nodeId, List<String> hostnames, int portBase, ClusteredService clusteredService) {
        return ClusterConfig.create(nodeId, hostnames, hostnames, portBase, clusteredService, new ClusteredService[0]);
    }

    public void errorHandler(ErrorHandler errorHandler) {
        this.mediaDriverContext.errorHandler(errorHandler);
        this.archiveContext.errorHandler(errorHandler);
        this.aeronArchiveContext.errorHandler(errorHandler);
        this.consensusModuleContext.errorHandler(errorHandler);
        this.clusteredServiceContexts.forEach(ctx -> ctx.errorHandler(errorHandler));
    }

    public void aeronDirectoryName(String aeronDir) {
        this.mediaDriverContext.aeronDirectoryName(aeronDir);
        this.archiveContext.aeronDirectoryName(aeronDir);
        this.aeronArchiveContext.aeronDirectoryName(aeronDir);
        this.consensusModuleContext.aeronDirectoryName(aeronDir);
        this.clusteredServiceContexts.forEach(ctx -> ctx.aeronDirectoryName(aeronDir));
    }

    public void baseDir(File baseDir) {
        this.archiveContext.archiveDir(new File(baseDir, ARCHIVE_SUB_DIR));
        this.consensusModuleContext.clusterDir(new File(baseDir, CLUSTER_SUB_DIR));
        this.clusteredServiceContexts.forEach(ctx -> ctx.clusterDir(new File(baseDir, CLUSTER_SUB_DIR)));
    }

    public MediaDriver.Context mediaDriverContext() {
        return this.mediaDriverContext;
    }

    public Archive.Context archiveContext() {
        return this.archiveContext;
    }

    public AeronArchive.Context aeronArchiveContext() {
        return this.aeronArchiveContext;
    }

    public ConsensusModule.Context consensusModuleContext() {
        return this.consensusModuleContext;
    }

    public ClusteredServiceContainer.Context clusteredServiceContext() {
        return this.clusteredServiceContexts.get(0);
    }

    public List<ClusteredServiceContainer.Context> clusteredServiceContexts() {
        return this.clusteredServiceContexts;
    }

    public int memberId() {
        return this.memberId;
    }

    public String ingressHostname() {
        return this.ingressHostname;
    }

    public String clusterHostname() {
        return this.clusterHostname;
    }

    public static String clusterMembers(List<String> ingressHostnames, List<String> clusterHostnames, int portBase) {
        return ClusterConfig.clusterMembers(0, ingressHostnames, clusterHostnames, portBase);
    }

    public static String clusterMembers(int startingMemberId, List<String> ingressHostnames, List<String> clusterHostnames, int portBase) {
        if (ingressHostnames.size() != clusterHostnames.size()) {
            throw new IllegalArgumentException("ingressHostnames and clusterHostnames must be the same size");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ingressHostnames.size(); ++i) {
            int memberId = i + startingMemberId;
            sb.append(memberId);
            sb.append(',').append(ClusterConfig.endpoint(memberId, ingressHostnames.get(i), portBase, 2));
            sb.append(',').append(ClusterConfig.endpoint(memberId, clusterHostnames.get(i), portBase, 3));
            sb.append(',').append(ClusterConfig.endpoint(memberId, clusterHostnames.get(i), portBase, 4));
            sb.append(',').append(ClusterConfig.endpoint(memberId, clusterHostnames.get(i), portBase, 5));
            sb.append(',').append(ClusterConfig.endpoint(memberId, clusterHostnames.get(i), portBase, 1));
            sb.append('|');
        }
        return sb.toString();
    }

    public static String ingressEndpoints(List<String> hostnames, int portBase, int clientFacingPortOffset) {
        return ClusterConfig.ingressEndpoints(0, hostnames, portBase, clientFacingPortOffset);
    }

    public static String ingressEndpoints(int startingMemberId, List<String> hostnames, int portBase, int clientFacingPortOffset) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hostnames.size(); ++i) {
            int memberId = i + startingMemberId;
            sb.append(memberId).append('=');
            sb.append(hostnames.get(i)).append(':').append(ClusterConfig.calculatePort(memberId, portBase, clientFacingPortOffset));
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static int calculatePort(int nodeId, int portBase, int offset) {
        return portBase + nodeId * 100 + offset;
    }

    private static String udpChannel(int nodeId, String hostname, int portBase, int portOffset) {
        int port = ClusterConfig.calculatePort(nodeId, portBase, portOffset);
        return "aeron:udp?endpoint=" + hostname + ":" + port;
    }

    private static String endpoint(int nodeId, String hostname, int portBase, int portOffset) {
        return hostname + ":" + ClusterConfig.calculatePort(nodeId, portBase, portOffset);
    }
}

