/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.counter.validation;

import io.aeron.counter.CounterInfo;
import io.aeron.counter.validation.Validation;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

final class ValidationReport {
    private final List<Validation> validations = new ArrayList<Validation>();

    ValidationReport() {
    }

    void addValidation(CounterInfo counterInfo, BiConsumer<Validation, CounterInfo> validateFunc) {
        Validation validation = new Validation(counterInfo.name);
        this.validate(validateFunc, validation, counterInfo);
        this.validations.add(validation);
    }

    void addValidation(boolean valid, String name, String message) {
        Validation validation = new Validation(name);
        if (valid) {
            validation.valid(message);
        } else {
            validation.invalid(message);
        }
        this.validations.add(validation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(BiConsumer<Validation, CounterInfo> func, Validation validation, CounterInfo c) {
        try {
            func.accept(validation, c);
        }
        catch (Exception e) {
            validation.invalid(e.getMessage());
            e.printStackTrace(validation.out());
        }
        finally {
            validation.close();
        }
    }

    void printOn(PrintStream out) {
        this.validations.forEach(validation -> validation.printOn(out));
    }

    void printFailuresOn(PrintStream out) {
        this.validations.stream().filter(validation -> !validation.isValid()).forEach(validation -> validation.printOn(out));
    }
}

