/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.version;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.aeron.version.Versioned"})
@SupportedOptions(value={"io.aeron.version", "io.aeron.gitsha"})
public class VersionProcessor
extends AbstractProcessor {
    private static final String VERSION_IMPL = "\n    @Override\n    public String toString()\n    {\n        return VERSION;\n    }\n\n    public int majorVersion()\n    {\n        return MAJOR_VERSION;\n    }\n\n    public int minorVersion()\n    {\n        return MINOR_VERSION;\n    }\n\n    public int patchVersion()\n    {\n        return PATCH_VERSION;\n    }\n\n    public String gitSha()\n    {\n        return GIT_SHA;\n    }";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : elementsAnnotatedWith) {
                PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(element);
                String packageName = pkg.getQualifiedName().toString();
                String className = element.getSimpleName() + "Version";
                try {
                    JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(packageName + '.' + className, new Element[0]);
                    PrintWriter out = new PrintWriter(sourceFile.openWriter());
                    Throwable throwable = null;
                    try {
                        String versionString = this.processingEnv.getOptions().get("io.aeron.version");
                        VersionInformation info = new VersionInformation(versionString);
                        String gitSha = this.processingEnv.getOptions().get("io.aeron.gitsha");
                        out.printf("package %s;%n", packageName);
                        out.println();
                        out.printf("public class %s%n implements io.aeron.version.Version%n", className);
                        out.printf("{%n", new Object[0]);
                        out.printf("    public static final String VERSION = \"%s\";%n", versionString);
                        out.printf("    public static final int MAJOR_VERSION = %s;%n", info.major);
                        out.printf("    public static final int MINOR_VERSION = %s;%n", info.minor);
                        out.printf("    public static final int PATCH_VERSION = %s;%n", info.patch);
                        out.printf("    public static final String GIT_SHA = \"%s\";%n", gitSha);
                        out.println(VERSION_IMPL);
                        out.printf("}%n", new Object[0]);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    private static class VersionInformation {
        private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+).([0-9]+).([0-9]+)(?:-.+)?");
        private final int major;
        private final int minor;
        private final int patch;

        VersionInformation(String versionString) {
            Matcher matcher = VERSION_PATTERN.matcher(versionString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("The version string: '" + versionString + "' is not valid");
            }
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.patch = Integer.parseInt(matcher.group(3));
        }
    }
}

