/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.AbstractListRecordingsSession;
import io.aeron.archive.Catalog;
import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.ControlSession;
import org.agrona.concurrent.UnsafeBuffer;

class ListRecordingsSession
extends AbstractListRecordingsSession {
    private final long limitId;
    private long recordingId;

    ListRecordingsSession(long correlationId, long fromRecordingId, int count, Catalog catalog, ControlResponseProxy proxy, ControlSession controlSession, UnsafeBuffer descriptorBuffer) {
        super(correlationId, catalog, proxy, controlSession, descriptorBuffer);
        this.recordingId = fromRecordingId;
        this.limitId = fromRecordingId + (long)count;
    }

    @Override
    protected int sendDescriptors() {
        int totalBytesSent = 0;
        for (int recordsScanned = 0; this.recordingId < this.limitId && recordsScanned < 256; ++recordsScanned) {
            if (!this.catalog.wrapDescriptor(this.recordingId, this.descriptorBuffer)) {
                this.controlSession.sendRecordingUnknown(this.correlationId, this.recordingId, this.proxy);
                this.isDone = true;
                break;
            }
            if (Catalog.isValidDescriptor(this.descriptorBuffer)) {
                int bytesSent = this.controlSession.sendDescriptor(this.correlationId, this.descriptorBuffer, this.proxy);
                if (bytesSent == 0) {
                    this.isDone = this.controlSession.isDone();
                    break;
                }
                totalBytesSent += bytesSent;
            }
            ++this.recordingId;
        }
        if (this.recordingId >= this.limitId) {
            this.isDone = true;
        }
        return totalBytesSent;
    }
}

