/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.ChallengeDecoder;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.SemanticVersion;

public class ControlResponsePoller
implements ControlledFragmentHandler {
    public static final int FRAGMENT_LIMIT = 10;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final ChallengeDecoder challengeDecoder = new ChallengeDecoder();
    private final Subscription subscription;
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler((ControlledFragmentHandler)this);
    private long controlSessionId = -1L;
    private long correlationId = -1L;
    private long relevantId = -1L;
    private int version = 0;
    private final int fragmentLimit;
    private ControlResponseCode code;
    private String errorMessage;
    private byte[] encodedChallenge = null;
    private boolean isPollComplete = false;

    private ControlResponsePoller(Subscription subscription, int fragmentLimit) {
        this.subscription = subscription;
        this.fragmentLimit = fragmentLimit;
    }

    public ControlResponsePoller(Subscription subscription) {
        this(subscription, 10);
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public int poll() {
        this.controlSessionId = -1L;
        this.correlationId = -1L;
        this.relevantId = -1L;
        this.version = 0;
        this.errorMessage = null;
        this.encodedChallenge = null;
        this.isPollComplete = false;
        return this.subscription.controlledPoll((ControlledFragmentHandler)this.fragmentAssembler, this.fragmentLimit);
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public long relevantId() {
        return this.relevantId;
    }

    public int version() {
        return this.version;
    }

    public boolean isPollComplete() {
        return this.isPollComplete;
    }

    public ControlResponseCode code() {
        return this.code;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public boolean wasChallenged() {
        return null != this.encodedChallenge;
    }

    public byte[] encodedChallenge() {
        return this.encodedChallenge;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        if (this.isPollComplete) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        if (this.messageHeaderDecoder.templateId() == 1) {
            this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            this.controlSessionId = this.controlResponseDecoder.controlSessionId();
            this.correlationId = this.controlResponseDecoder.correlationId();
            this.relevantId = this.controlResponseDecoder.relevantId();
            this.code = this.controlResponseDecoder.code();
            this.version = this.controlResponseDecoder.version();
            this.errorMessage = this.controlResponseDecoder.errorMessage();
            this.isPollComplete = true;
            return ControlledFragmentHandler.Action.BREAK;
        }
        if (this.messageHeaderDecoder.templateId() == 59) {
            this.challengeDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            this.controlSessionId = this.challengeDecoder.controlSessionId();
            this.correlationId = this.challengeDecoder.correlationId();
            this.relevantId = -1L;
            this.code = ControlResponseCode.NULL_VAL;
            this.version = this.challengeDecoder.version();
            this.errorMessage = "";
            int encodedChallengeLength = this.challengeDecoder.encodedChallengeLength();
            this.encodedChallenge = new byte[encodedChallengeLength];
            this.challengeDecoder.getEncodedChallenge(this.encodedChallenge, 0, encodedChallengeLength);
            this.isPollComplete = true;
            return ControlledFragmentHandler.Action.BREAK;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public String toString() {
        return "ControlResponsePoller{controlSessionId=" + this.controlSessionId + ", correlationId=" + this.correlationId + ", relevantId=" + this.relevantId + ", code=" + (Object)((Object)this.code) + ", version=" + SemanticVersion.toString((int)this.version) + ", errorMessage='" + this.errorMessage + '\'' + ", isPollComplete=" + this.isPollComplete + '}';
    }
}

