/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.MetaAttribute;
import io.aeron.archive.codecs.RecordingDescriptorHeaderDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class RecordingDescriptorHeaderEncoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 21;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 4;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordingDescriptorHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 21;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 4;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RecordingDescriptorHeaderEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 32);
        return this;
    }

    public RecordingDescriptorHeaderEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(32).templateId(21).schemaId(101).version(4);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int lengthId() {
        return 1;
    }

    public static int lengthSinceVersion() {
        return 0;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 4;
    }

    public static String lengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lengthMinValue() {
        return -2147483647;
    }

    public static int lengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordingDescriptorHeaderEncoder length(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int validId() {
        return 2;
    }

    public static int validSinceVersion() {
        return 0;
    }

    public static int validEncodingOffset() {
        return 4;
    }

    public static int validEncodingLength() {
        return 1;
    }

    public static String validMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte validNullValue() {
        return -128;
    }

    public static byte validMinValue() {
        return -127;
    }

    public static byte validMaxValue() {
        return 127;
    }

    public RecordingDescriptorHeaderEncoder valid(byte value) {
        this.buffer.putByte(this.offset + 4, value);
        return this;
    }

    public static int reservedId() {
        return 3;
    }

    public static int reservedSinceVersion() {
        return 0;
    }

    public static int reservedEncodingOffset() {
        return 31;
    }

    public static int reservedEncodingLength() {
        return 1;
    }

    public static String reservedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte reservedNullValue() {
        return -128;
    }

    public static byte reservedMinValue() {
        return -127;
    }

    public static byte reservedMaxValue() {
        return 127;
    }

    public RecordingDescriptorHeaderEncoder reserved(byte value) {
        this.buffer.putByte(this.offset + 31, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        RecordingDescriptorHeaderDecoder decoder = new RecordingDescriptorHeaderDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 32, 4);
        return decoder.appendTo(builder);
    }
}

