/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.status;

import io.aeron.Aeron;
import io.aeron.Counter;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersReader;

public class RecordingPos {
    public static final int RECORDING_POSITION_TYPE_ID = 100;
    public static final long NULL_RECORDING_ID = -1L;
    public static final String NAME = "rec-pos";
    public static final int RECORDING_ID_OFFSET = 0;
    public static final int SESSION_ID_OFFSET = 8;
    public static final int SOURCE_IDENTITY_LENGTH_OFFSET = 12;
    public static final int SOURCE_IDENTITY_OFFSET = 16;

    public static Counter allocate(Aeron aeron, UnsafeBuffer tempBuffer, long recordingId, int sessionId, int streamId, String strippedChannel, String sourceIdentity) {
        tempBuffer.putLong(0, recordingId);
        tempBuffer.putInt(8, sessionId);
        int sourceIdentityLength = Math.min(sourceIdentity.length(), 96);
        tempBuffer.putStringAscii(12, sourceIdentity);
        int keyLength = 16 + sourceIdentityLength;
        int labelOffset = BitUtil.align((int)keyLength, (int)4);
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset, "rec-pos: ");
        labelLength += tempBuffer.putLongAscii(labelOffset + labelLength, recordingId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putIntAscii(labelOffset + labelLength, sessionId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putIntAscii(labelOffset + labelLength, streamId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, strippedChannel, 0, 380 - labelLength);
        return aeron.addCounter(100, (DirectBuffer)tempBuffer, 0, keyLength, (DirectBuffer)tempBuffer, labelOffset, labelLength);
    }

    public static int findCounterIdByRecording(CountersReader countersReader, long recordingId) {
        AtomicBuffer buffer = countersReader.metaDataBuffer();
        int size = countersReader.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = countersReader.getCounterState(i);
            if (counterState == 1 && countersReader.getCounterTypeId(i) == 100) {
                if (buffer.getLong(CountersReader.metaDataOffset((int)i) + 16 + 0) != recordingId) continue;
                return i;
            }
            if (0 == counterState) break;
        }
        return -1;
    }

    public static int findCounterIdBySession(CountersReader countersReader, int sessionId) {
        AtomicBuffer buffer = countersReader.metaDataBuffer();
        int size = countersReader.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = countersReader.getCounterState(i);
            if (counterState == 1 && countersReader.getCounterTypeId(i) == 100) {
                if (buffer.getInt(CountersReader.metaDataOffset((int)i) + 16 + 8) != sessionId) continue;
                return i;
            }
            if (0 == counterState) break;
        }
        return -1;
    }

    public static long getRecordingId(CountersReader countersReader, int counterId) {
        AtomicBuffer buffer = countersReader.metaDataBuffer();
        if (countersReader.getCounterState(counterId) == 1 && countersReader.getCounterTypeId(counterId) == 100) {
            return buffer.getLong(CountersReader.metaDataOffset((int)counterId) + 16 + 0);
        }
        return -1L;
    }

    public static String getSourceIdentity(CountersReader counters, int counterId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && counters.getCounterTypeId(counterId) == 100) {
            int recordOffset = CountersReader.metaDataOffset((int)counterId);
            return buffer.getStringAscii(recordOffset + 16 + 12);
        }
        return null;
    }

    public static boolean isActive(CountersReader counters, int counterId, long recordingId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        int recordOffset = CountersReader.metaDataOffset((int)counterId);
        return counters.getCounterTypeId(counterId) == 100 && buffer.getLong(recordOffset + 16 + 0) == recordingId && counters.getCounterState(counterId) == 1;
    }
}

