/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.CommonContext;
import io.aeron.Counter;
import io.aeron.RethrowingErrorHandler;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ArchiveMarkFile;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.Catalog;
import io.aeron.archive.DedicatedModeArchiveConductor;
import io.aeron.archive.SharedModeArchiveConductor;
import io.aeron.archive.checksum.Checksum;
import io.aeron.archive.checksum.Checksums;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.security.AuthenticatorSupplier;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.errors.LoggingErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.StatusIndicator;

public final class Archive
implements AutoCloseable {
    private final Context ctx;
    private final AgentRunner conductorRunner;
    private final AgentInvoker conductorInvoker;

    Archive(Context ctx) {
        try {
            ArchiveConductor conductor;
            ctx.conclude();
            this.ctx = ctx;
            ArchiveConductor archiveConductor = conductor = ArchiveThreadingMode.DEDICATED == ctx.threadingMode() ? new DedicatedModeArchiveConductor(ctx) : new SharedModeArchiveConductor(ctx);
            if (ArchiveThreadingMode.INVOKER == ctx.threadingMode()) {
                this.conductorInvoker = new AgentInvoker(ctx.errorHandler(), ctx.errorCounter(), (Agent)conductor);
                this.conductorRunner = null;
            } else {
                this.conductorInvoker = null;
                this.conductorRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), ctx.errorCounter(), (Agent)conductor);
            }
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles((String[])args);
        try (Archive ignore = Archive.launch();){
            new ShutdownSignalBarrier().await();
            System.out.println("Shutdown Archive...");
        }
    }

    public Context context() {
        return this.ctx;
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.conductorInvoker);
        CloseHelper.close((AutoCloseable)this.conductorRunner);
    }

    public AgentInvoker invoker() {
        return this.conductorInvoker;
    }

    public static Archive launch() {
        return Archive.launch(new Context());
    }

    public static Archive launch(Context ctx) {
        Archive archive = new Archive(ctx);
        if (ArchiveThreadingMode.INVOKER == ctx.threadingMode()) {
            archive.conductorInvoker.start();
        } else {
            AgentRunner.startOnThread((AgentRunner)archive.conductorRunner, (ThreadFactory)ctx.threadFactory());
        }
        return archive;
    }

    static String segmentFileName(long recordingId, long segmentBasePosition) {
        return recordingId + "-" + segmentBasePosition + ".rec";
    }

    static FileChannel channelForDirectorySync(File directory, int fileSyncLevel) {
        if (fileSyncLevel > 0) {
            try {
                return FileChannel.open(directory.toPath(), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final class Context
    implements Cloneable {
        private static final AtomicIntegerFieldUpdater<Context> IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isConcluded");
        private volatile int isConcluded;
        private boolean deleteArchiveOnStart = Configuration.deleteArchiveOnStart();
        private boolean ownsAeronClient = false;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private File archiveDir;
        private String archiveDirectoryName = Configuration.archiveDirName();
        private FileChannel archiveDirChannel;
        private Catalog catalog;
        private ArchiveMarkFile markFile;
        private AeronArchive.Context archiveClientContext;
        private AgentInvoker mediaDriverAgentInvoker;
        private String controlChannel = AeronArchive.Configuration.controlChannel();
        private int controlStreamId = AeronArchive.Configuration.controlStreamId();
        private String localControlChannel = AeronArchive.Configuration.localControlChannel();
        private int localControlStreamId = AeronArchive.Configuration.localControlStreamId();
        private boolean controlTermBufferSparse = AeronArchive.Configuration.controlTermBufferSparse();
        private int controlTermBufferLength = AeronArchive.Configuration.controlTermBufferLength();
        private int controlMtuLength = AeronArchive.Configuration.controlMtuLength();
        private String recordingEventsChannel = AeronArchive.Configuration.recordingEventsChannel();
        private int recordingEventsStreamId = AeronArchive.Configuration.recordingEventsStreamId();
        private boolean recordingEventsEnabled = AeronArchive.Configuration.recordingEventsEnabled();
        private String replicationChannel = Configuration.replicationChannel();
        private long connectTimeoutNs = Configuration.connectTimeoutNs();
        private long replayLingerTimeoutNs = Configuration.replayLingerTimeoutNs();
        private long maxCatalogEntries = Configuration.maxCatalogEntries();
        private long catalogCapacity = Configuration.catalogCapacity();
        private int segmentFileLength = Configuration.segmentFileLength();
        private int fileSyncLevel = Configuration.fileSyncLevel();
        private int catalogFileSyncLevel = Configuration.catalogFileSyncLevel();
        private int maxConcurrentRecordings = Configuration.maxConcurrentRecordings();
        private int maxConcurrentReplays = Configuration.maxConcurrentReplays();
        private int fileIoMaxLength = Configuration.fileIoMaxLength();
        private ArchiveThreadingMode threadingMode = Configuration.threadingMode();
        private ThreadFactory threadFactory;
        private CountDownLatch abortLatch;
        private Supplier<IdleStrategy> idleStrategySupplier;
        private Supplier<IdleStrategy> replayerIdleStrategySupplier;
        private Supplier<IdleStrategy> recorderIdleStrategySupplier;
        private EpochClock epochClock;
        private AuthenticatorSupplier authenticatorSupplier;
        private Counter controlSessionsCounter;
        private int errorBufferLength = 0;
        private ErrorHandler errorHandler;
        private AtomicCounter errorCounter;
        private CountedErrorHandler countedErrorHandler;
        private Checksum recordChecksum;
        private Checksum replayChecksum;
        private UnsafeBuffer dataBuffer;
        private UnsafeBuffer replayBuffer;
        private UnsafeBuffer recordChecksumBuffer;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
                throw new ConcurrentConcludeException();
            }
            if (this.catalogFileSyncLevel < this.fileSyncLevel) {
                throw new ConfigurationException("catalogFileSyncLevel " + this.catalogFileSyncLevel + " < fileSyncLevel " + this.fileSyncLevel);
            }
            if (this.fileIoMaxLength < 65536 || !BitUtil.isPowerOfTwo((int)this.fileIoMaxLength)) {
                throw new ConfigurationException("invalid fileIoMaxLength=" + this.fileIoMaxLength);
            }
            if (null == this.archiveDir) {
                this.archiveDir = new File(this.archiveDirectoryName);
            }
            if (this.deleteArchiveOnStart) {
                IoUtil.delete((File)this.archiveDir, (boolean)false);
            }
            if (!this.archiveDir.exists() && !this.archiveDir.mkdirs()) {
                throw new ArchiveException("failed to create archive dir: " + this.archiveDir.getAbsolutePath());
            }
            this.archiveDirChannel = Archive.channelForDirectorySync(this.archiveDir, this.catalogFileSyncLevel);
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null != this.aeron) {
                this.aeronDirectoryName = this.aeron.context().aeronDirectoryName();
            }
            if (null == this.markFile) {
                if (0 == this.errorBufferLength && null == this.errorHandler) {
                    this.errorBufferLength = Configuration.errorBufferLength();
                }
                this.markFile = new ArchiveMarkFile(this);
            }
            if (null == this.errorHandler) {
                this.errorHandler = new LoggingErrorHandler(new DistinctErrorLog(this.markFile.errorBuffer(), this.epochClock, StandardCharsets.US_ASCII));
            }
            if (null == this.aeron) {
                this.ownsAeronClient = true;
                this.aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).errorHandler(this.errorHandler).epochClock(this.epochClock).driverAgentInvoker(this.mediaDriverAgentInvoker).useConductorAgentInvoker(true).subscriberErrorHandler((ErrorHandler)RethrowingErrorHandler.INSTANCE).awaitingIdleStrategy((IdleStrategy)YieldingIdleStrategy.INSTANCE).clientLock((Lock)NoOpLock.INSTANCE));
                if (null == this.errorCounter) {
                    this.errorCounter = this.aeron.addCounter(101, "Archive Errors");
                }
            }
            Objects.requireNonNull(this.errorCounter, "Error counter must be supplied if aeron client is");
            if (null == this.countedErrorHandler) {
                this.countedErrorHandler = new CountedErrorHandler(this.errorHandler, this.errorCounter);
                if (this.ownsAeronClient) {
                    this.aeron.context().errorHandler((ErrorHandler)this.countedErrorHandler);
                }
            }
            if (null == this.threadFactory) {
                this.threadFactory = Thread::new;
            }
            if (null == this.idleStrategySupplier) {
                this.idleStrategySupplier = Configuration.idleStrategySupplier(null);
            }
            if (ArchiveThreadingMode.DEDICATED == this.threadingMode) {
                if (null == this.recorderIdleStrategySupplier) {
                    this.recorderIdleStrategySupplier = Configuration.recorderIdleStrategySupplier(null);
                    if (null == this.recorderIdleStrategySupplier) {
                        this.recorderIdleStrategySupplier = this.idleStrategySupplier;
                    }
                }
                if (null == this.replayerIdleStrategySupplier) {
                    this.replayerIdleStrategySupplier = Configuration.replayerIdleStrategySupplier(null);
                    if (null == this.replayerIdleStrategySupplier) {
                        this.replayerIdleStrategySupplier = this.idleStrategySupplier;
                    }
                }
            }
            if (!BitUtil.isPowerOfTwo((int)this.segmentFileLength)) {
                throw new ArchiveException("segment file length not a power of 2: " + this.segmentFileLength);
            }
            if (this.segmentFileLength < 65536 || this.segmentFileLength > 0x40000000) {
                throw new ArchiveException("segment file length not in valid range: " + this.segmentFileLength);
            }
            if (null == this.authenticatorSupplier) {
                this.authenticatorSupplier = Configuration.authenticatorSupplier();
            }
            this.concludeRecordChecksum();
            this.concludeReplayChecksum();
            if (null == this.catalog) {
                this.catalog = new Catalog(this.archiveDir, this.archiveDirChannel, this.catalogFileSyncLevel, this.catalogCapacity, this.epochClock, this.recordChecksum, null != this.recordChecksum ? this.recordChecksumBuffer() : this.dataBuffer());
            }
            if (null == this.archiveClientContext) {
                this.archiveClientContext = new AeronArchive.Context();
            }
            this.archiveClientContext.aeron(this.aeron).lock((Lock)NoOpLock.INSTANCE).errorHandler(this.errorHandler);
            if (null == this.controlSessionsCounter) {
                this.controlSessionsCounter = this.aeron.addCounter(102, "Archive Control Sessions");
            }
            int expectedCount = ArchiveThreadingMode.DEDICATED == this.threadingMode ? 2 : 0;
            this.abortLatch = new CountDownLatch(expectedCount += this.aeron.conductorAgentInvoker() == null ? 1 : 0);
            this.markFile.signalReady();
        }

        public Context deleteArchiveOnStart(boolean deleteArchiveOnStart) {
            this.deleteArchiveOnStart = deleteArchiveOnStart;
            return this;
        }

        public boolean deleteArchiveOnStart() {
            return this.deleteArchiveOnStart;
        }

        public Context archiveDirectoryName(String archiveDirectoryName) {
            this.archiveDirectoryName = archiveDirectoryName;
            return this;
        }

        public String archiveDirectoryName() {
            return this.archiveDirectoryName;
        }

        public File archiveDir() {
            return this.archiveDir;
        }

        public Context archiveDir(File archiveDir) {
            this.archiveDir = archiveDir;
            return this;
        }

        public FileChannel archiveDirChannel() {
            return this.archiveDirChannel;
        }

        public Context archiveClientContext(AeronArchive.Context archiveContext) {
            this.archiveClientContext = archiveContext;
            return this;
        }

        public AeronArchive.Context archiveClientContext() {
            return this.archiveClientContext;
        }

        public String controlChannel() {
            return this.controlChannel;
        }

        public Context controlChannel(String controlChannel) {
            this.controlChannel = controlChannel;
            return this;
        }

        public int controlStreamId() {
            return this.controlStreamId;
        }

        public Context controlStreamId(int controlStreamId) {
            this.controlStreamId = controlStreamId;
            return this;
        }

        public String localControlChannel() {
            return this.localControlChannel;
        }

        public Context localControlChannel(String controlChannel) {
            this.localControlChannel = controlChannel;
            return this;
        }

        public int localControlStreamId() {
            return this.localControlStreamId;
        }

        public Context controlTermBufferSparse(boolean controlTermBufferSparse) {
            this.controlTermBufferSparse = controlTermBufferSparse;
            return this;
        }

        public boolean controlTermBufferSparse() {
            return this.controlTermBufferSparse;
        }

        public Context controlTermBufferLength(int controlTermBufferLength) {
            this.controlTermBufferLength = controlTermBufferLength;
            return this;
        }

        public int controlTermBufferLength() {
            return this.controlTermBufferLength;
        }

        public Context controlMtuLength(int controlMtuLength) {
            this.controlMtuLength = controlMtuLength;
            return this;
        }

        public int controlMtuLength() {
            return this.controlMtuLength;
        }

        public Context localControlStreamId(int controlStreamId) {
            this.localControlStreamId = controlStreamId;
            return this;
        }

        public String recordingEventsChannel() {
            return this.recordingEventsChannel;
        }

        public Context recordingEventsChannel(String recordingEventsChannel) {
            this.recordingEventsChannel = recordingEventsChannel;
            return this;
        }

        public int recordingEventsStreamId() {
            return this.recordingEventsStreamId;
        }

        public Context recordingEventsStreamId(int recordingEventsStreamId) {
            this.recordingEventsStreamId = recordingEventsStreamId;
            return this;
        }

        public boolean recordingEventsEnabled() {
            return this.recordingEventsEnabled;
        }

        public Context recordingEventsEnabled(boolean recordingEventsEnabled) {
            this.recordingEventsEnabled = recordingEventsEnabled;
            return this;
        }

        public String replicationChannel() {
            return this.replicationChannel;
        }

        public Context replicationChannel(String replicationChannel) {
            this.replicationChannel = replicationChannel;
            return this;
        }

        public Context connectTimeoutNs(long connectTimeoutNs) {
            this.connectTimeoutNs = connectTimeoutNs;
            return this;
        }

        public long connectTimeoutNs() {
            return this.connectTimeoutNs;
        }

        public Context replayLingerTimeoutNs(long replayLingerTimeoutNs) {
            this.replayLingerTimeoutNs = replayLingerTimeoutNs;
            return this;
        }

        public long replayLingerTimeoutNs() {
            return this.replayLingerTimeoutNs;
        }

        public Context recordChecksum(Checksum recordChecksum) {
            this.recordChecksum = recordChecksum;
            return this;
        }

        public Checksum recordChecksum() {
            return this.recordChecksum;
        }

        public Context replayChecksum(Checksum replayChecksum) {
            this.replayChecksum = replayChecksum;
            return this;
        }

        public Checksum replayChecksum() {
            return this.replayChecksum;
        }

        public Context idleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.idleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategySupplier.get();
        }

        public Context recorderIdleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.recorderIdleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy recorderIdleStrategy() {
            return this.recorderIdleStrategySupplier.get();
        }

        public Context replayerIdleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.replayerIdleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy replayerIdleStrategy() {
            return this.replayerIdleStrategySupplier.get();
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        int segmentFileLength() {
            return this.segmentFileLength;
        }

        public Context segmentFileLength(int segmentFileLength) {
            this.segmentFileLength = segmentFileLength;
            return this;
        }

        int fileSyncLevel() {
            return this.fileSyncLevel;
        }

        public Context fileSyncLevel(int syncLevel) {
            this.fileSyncLevel = syncLevel;
            return this;
        }

        int catalogFileSyncLevel() {
            return this.catalogFileSyncLevel;
        }

        public Context catalogFileSyncLevel(int syncLevel) {
            this.catalogFileSyncLevel = syncLevel;
            return this;
        }

        AgentInvoker mediaDriverAgentInvoker() {
            return this.mediaDriverAgentInvoker;
        }

        public Context mediaDriverAgentInvoker(AgentInvoker mediaDriverAgentInvoker) {
            this.mediaDriverAgentInvoker = mediaDriverAgentInvoker;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Context countedErrorHandler(CountedErrorHandler countedErrorHandler) {
            this.countedErrorHandler = countedErrorHandler;
            return this;
        }

        public CountedErrorHandler countedErrorHandler() {
            return this.countedErrorHandler;
        }

        public ArchiveThreadingMode threadingMode() {
            return this.threadingMode;
        }

        public Context threadingMode(ArchiveThreadingMode threadingMode) {
            this.threadingMode = threadingMode;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Context errorBufferLength(int errorBufferLength) {
            this.errorBufferLength = errorBufferLength;
            return this;
        }

        public int errorBufferLength() {
            return this.errorBufferLength;
        }

        public AtomicCounter errorCounter() {
            return this.errorCounter;
        }

        public Context errorCounter(AtomicCounter errorCounter) {
            this.errorCounter = errorCounter;
            return this;
        }

        public Counter controlSessionsCounter() {
            return this.controlSessionsCounter;
        }

        public Context controlSessionsCounter(Counter controlSessionsCounter) {
            this.controlSessionsCounter = controlSessionsCounter;
            return this;
        }

        public int maxConcurrentRecordings() {
            return this.maxConcurrentRecordings;
        }

        public Context maxConcurrentRecordings(int maxConcurrentRecordings) {
            this.maxConcurrentRecordings = maxConcurrentRecordings;
            return this;
        }

        public int maxConcurrentReplays() {
            return this.maxConcurrentReplays;
        }

        public Context maxConcurrentReplays(int maxConcurrentReplays) {
            this.maxConcurrentReplays = maxConcurrentReplays;
            return this;
        }

        public int fileIoMaxLength() {
            return this.fileIoMaxLength;
        }

        public Context fileIoMaxLength(int fileIoMaxLength) {
            this.fileIoMaxLength = fileIoMaxLength;
            return this;
        }

        @Deprecated
        public void deleteArchiveDirectory() {
            this.deleteDirectory();
        }

        public void deleteDirectory() {
            if (null != this.archiveDir) {
                IoUtil.delete((File)this.archiveDir, (boolean)false);
            }
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public Context catalog(Catalog catalog) {
            this.catalog = catalog;
            return this;
        }

        public Catalog catalog() {
            return this.catalog;
        }

        public Context archiveMarkFile(ArchiveMarkFile archiveMarkFile) {
            this.markFile = archiveMarkFile;
            return this;
        }

        public ArchiveMarkFile archiveMarkFile() {
            return this.markFile;
        }

        @Deprecated
        public Context maxCatalogEntries(long maxCatalogEntries) {
            this.maxCatalogEntries = maxCatalogEntries;
            return this;
        }

        @Deprecated
        public long maxCatalogEntries() {
            return this.maxCatalogEntries;
        }

        public Context catalogCapacity(long catalogCapacity) {
            this.catalogCapacity = catalogCapacity;
            return this;
        }

        public long catalogCapacity() {
            return this.catalogCapacity;
        }

        public AuthenticatorSupplier authenticatorSupplier() {
            return this.authenticatorSupplier;
        }

        public Context authenticatorSupplier(AuthenticatorSupplier authenticatorSupplier) {
            this.authenticatorSupplier = authenticatorSupplier;
            return this;
        }

        CountDownLatch abortLatch() {
            return this.abortLatch;
        }

        void concludeRecordChecksum() {
            String checksumClass;
            if (null == this.recordChecksum && !Strings.isEmpty((String)(checksumClass = Configuration.recordChecksum()))) {
                this.recordChecksum = Checksums.newInstance(checksumClass);
            }
        }

        void concludeReplayChecksum() {
            String checksumClass;
            if (null == this.replayChecksum && !Strings.isEmpty((String)(checksumClass = Configuration.replayChecksum()))) {
                this.replayChecksum = Checksums.newInstance(checksumClass);
            }
        }

        Context dataBuffer(UnsafeBuffer dataBuffer) {
            this.dataBuffer = dataBuffer;
            return this;
        }

        UnsafeBuffer dataBuffer() {
            if (null == this.dataBuffer) {
                this.dataBuffer = this.allocateBuffer();
            }
            return this.dataBuffer;
        }

        Context replayBuffer(UnsafeBuffer replayBuffer) {
            this.replayBuffer = replayBuffer;
            return this;
        }

        UnsafeBuffer replayBuffer() {
            if (ArchiveThreadingMode.DEDICATED != this.threadingMode) {
                return this.dataBuffer();
            }
            if (null == this.replayBuffer) {
                this.replayBuffer = this.allocateBuffer();
            }
            return this.replayBuffer;
        }

        Context recordChecksumBuffer(UnsafeBuffer recordChecksumBuffer) {
            this.recordChecksumBuffer = recordChecksumBuffer;
            return this;
        }

        UnsafeBuffer recordChecksumBuffer() {
            if (null == this.recordChecksum) {
                return null;
            }
            if (ArchiveThreadingMode.DEDICATED != this.threadingMode) {
                return this.dataBuffer();
            }
            if (null == this.recordChecksumBuffer) {
                this.recordChecksumBuffer = this.allocateBuffer();
            }
            return this.recordChecksumBuffer;
        }

        private UnsafeBuffer allocateBuffer() {
            return new UnsafeBuffer(BufferUtil.allocateDirectAligned((int)this.fileIoMaxLength, (int)64));
        }

        public void close() {
            CloseHelper.close((ErrorHandler)this.countedErrorHandler, (AutoCloseable)this.catalog);
            CloseHelper.close((ErrorHandler)this.countedErrorHandler, (AutoCloseable)this.markFile);
            CloseHelper.close((ErrorHandler)this.countedErrorHandler, (AutoCloseable)this.archiveDirChannel);
            this.archiveDirChannel = null;
            CloseHelper.quietClose((AutoCloseable)this.errorCounter);
            if (this.errorHandler instanceof AutoCloseable) {
                CloseHelper.quietClose((AutoCloseable)((AutoCloseable)this.errorHandler));
            }
            if (this.ownsAeronClient) {
                CloseHelper.close((AutoCloseable)this.aeron);
            } else {
                CloseHelper.close((ErrorHandler)this.countedErrorHandler, (AutoCloseable)this.controlSessionsCounter);
            }
        }
    }

    public static final class Configuration {
        static final String CATALOG_FILE_NAME = "archive.catalog";
        static final String RECORDING_SEGMENT_SUFFIX = ".rec";
        public static final int FILE_IO_MAX_LENGTH_DEFAULT = 0x100000;
        public static final String FILE_IO_MAX_LENGTH_PROP_NAME = "aeron.archive.file.io.max.length";
        public static final String ARCHIVE_DIR_PROP_NAME = "aeron.archive.dir";
        public static final String ARCHIVE_DIR_DEFAULT = "aeron-archive";
        public static final String SEGMENT_FILE_LENGTH_PROP_NAME = "aeron.archive.segment.file.length";
        public static final int SEGMENT_FILE_LENGTH_DEFAULT = 0x8000000;
        public static final String FILE_SYNC_LEVEL_PROP_NAME = "aeron.archive.file.sync.level";
        public static final int FILE_SYNC_LEVEL_DEFAULT = 0;
        public static final String CATALOG_FILE_SYNC_LEVEL_PROP_NAME = "aeron.archive.catalog.file.sync.level";
        public static final int CATALOG_FILE_SYNC_LEVEL_DEFAULT = 0;
        public static final String THREADING_MODE_PROP_NAME = "aeron.archive.threading.mode";
        public static final String ARCHIVE_IDLE_STRATEGY_PROP_NAME = "aeron.archive.idle.strategy";
        public static final String ARCHIVE_RECORDER_IDLE_STRATEGY_PROP_NAME = "aeron.archive.recorder.idle.strategy";
        public static final String ARCHIVE_REPLAYER_IDLE_STRATEGY_PROP_NAME = "aeron.archive.replayer.idle.strategy";
        public static final String DEFAULT_IDLE_STRATEGY = "org.agrona.concurrent.BackoffIdleStrategy";
        public static final String MAX_CONCURRENT_RECORDINGS_PROP_NAME = "aeron.archive.max.concurrent.recordings";
        public static final int MAX_CONCURRENT_RECORDINGS_DEFAULT = 20;
        public static final String MAX_CONCURRENT_REPLAYS_PROP_NAME = "aeron.archive.max.concurrent.replays";
        public static final int MAX_CONCURRENT_REPLAYS_DEFAULT = 20;
        @Deprecated
        public static final String MAX_CATALOG_ENTRIES_PROP_NAME = "aeron.archive.max.catalog.entries";
        @Deprecated
        public static final long MAX_CATALOG_ENTRIES_DEFAULT = 8192L;
        public static final String CATALOG_CAPACITY_PROP_NAME = "aeron.archive.catalog.capacity";
        public static final long CATALOG_CAPACITY_DEFAULT = 0x100000L;
        public static final String CONNECT_TIMEOUT_PROP_NAME = "aeron.archive.connect.timeout";
        public static final long CONNECT_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
        public static final String REPLAY_LINGER_TIMEOUT_PROP_NAME = "aeron.archive.replay.linger.timeout";
        public static final long REPLAY_LINGER_TIMEOUT_DEFAULT_NS = io.aeron.driver.Configuration.publicationLingerTimeoutNs();
        public static final String ARCHIVE_DIR_DELETE_ON_START_PROP_NAME = "aeron.archive.dir.delete.on.start";
        public static final String REPLICATION_CHANNEL_PROP_NAME = "aeron.archive.replication.channel";
        public static final String REPLICATION_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:0";
        public static final String AUTHENTICATOR_SUPPLIER_PROP_NAME = "aeron.archive.authenticator.supplier";
        public static final String AUTHENTICATOR_SUPPLIER_DEFAULT = "io.aeron.security.DefaultAuthenticatorSupplier";
        public static final int ARCHIVE_ERROR_COUNT_TYPE_ID = 101;
        public static final int ARCHIVE_CONTROL_SESSIONS_TYPE_ID = 102;
        public static final String ERROR_BUFFER_LENGTH_PROP_NAME = "aeron.archive.error.buffer.length";
        public static final int ERROR_BUFFER_LENGTH_DEFAULT = 0x100000;
        public static final String RECORD_CHECKSUM_PROP_NAME = "aeron.archive.record.checksum";
        public static final String REPLAY_CHECKSUM_PROP_NAME = "aeron.archive.replay.checksum";

        public static String archiveDirName() {
            return System.getProperty(ARCHIVE_DIR_PROP_NAME, ARCHIVE_DIR_DEFAULT);
        }

        public static int fileIoMaxLength() {
            return SystemUtil.getSizeAsInt((String)FILE_IO_MAX_LENGTH_PROP_NAME, (int)0x100000);
        }

        public static int segmentFileLength() {
            return SystemUtil.getSizeAsInt((String)SEGMENT_FILE_LENGTH_PROP_NAME, (int)0x8000000);
        }

        public static int fileSyncLevel() {
            return Integer.getInteger(FILE_SYNC_LEVEL_PROP_NAME, 0);
        }

        public static int catalogFileSyncLevel() {
            return Integer.getInteger(CATALOG_FILE_SYNC_LEVEL_PROP_NAME, 0);
        }

        public static ArchiveThreadingMode threadingMode() {
            return ArchiveThreadingMode.valueOf(System.getProperty(THREADING_MODE_PROP_NAME, ArchiveThreadingMode.DEDICATED.name()));
        }

        public static Supplier<IdleStrategy> idleStrategySupplier(StatusIndicator controllableStatus) {
            return () -> {
                String name = System.getProperty(ARCHIVE_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY);
                return io.aeron.driver.Configuration.agentIdleStrategy((String)name, (StatusIndicator)controllableStatus);
            };
        }

        public static Supplier<IdleStrategy> recorderIdleStrategySupplier(StatusIndicator controllableStatus) {
            String name = System.getProperty(ARCHIVE_RECORDER_IDLE_STRATEGY_PROP_NAME);
            if (null == name) {
                return null;
            }
            return () -> io.aeron.driver.Configuration.agentIdleStrategy((String)name, (StatusIndicator)controllableStatus);
        }

        public static Supplier<IdleStrategy> replayerIdleStrategySupplier(StatusIndicator controllableStatus) {
            String name = System.getProperty(ARCHIVE_REPLAYER_IDLE_STRATEGY_PROP_NAME);
            if (null == name) {
                return null;
            }
            return () -> io.aeron.driver.Configuration.agentIdleStrategy((String)name, (StatusIndicator)controllableStatus);
        }

        public static int maxConcurrentRecordings() {
            return Integer.getInteger(MAX_CONCURRENT_RECORDINGS_PROP_NAME, 20);
        }

        public static int maxConcurrentReplays() {
            return Integer.getInteger(MAX_CONCURRENT_REPLAYS_PROP_NAME, 20);
        }

        @Deprecated
        public static long maxCatalogEntries() {
            return Long.getLong(MAX_CATALOG_ENTRIES_PROP_NAME, 8192L);
        }

        public static long catalogCapacity() {
            return Long.getLong(CATALOG_CAPACITY_PROP_NAME, 0x100000L);
        }

        public static long connectTimeoutNs() {
            return SystemUtil.getDurationInNanos((String)CONNECT_TIMEOUT_PROP_NAME, (long)CONNECT_TIMEOUT_DEFAULT_NS);
        }

        public static long replayLingerTimeoutNs() {
            return SystemUtil.getDurationInNanos((String)REPLAY_LINGER_TIMEOUT_PROP_NAME, (long)REPLAY_LINGER_TIMEOUT_DEFAULT_NS);
        }

        public static boolean deleteArchiveOnStart() {
            return "true".equalsIgnoreCase(System.getProperty(ARCHIVE_DIR_DELETE_ON_START_PROP_NAME, "false"));
        }

        public static String replicationChannel() {
            return System.getProperty(REPLICATION_CHANNEL_PROP_NAME, REPLICATION_CHANNEL_DEFAULT);
        }

        public static int errorBufferLength() {
            return SystemUtil.getSizeAsInt((String)ERROR_BUFFER_LENGTH_PROP_NAME, (int)0x100000);
        }

        public static AuthenticatorSupplier authenticatorSupplier() {
            String supplierClassName = System.getProperty(AUTHENTICATOR_SUPPLIER_PROP_NAME, AUTHENTICATOR_SUPPLIER_DEFAULT);
            AuthenticatorSupplier supplier = null;
            try {
                supplier = (AuthenticatorSupplier)Class.forName(supplierClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
            return supplier;
        }

        public static String recordChecksum() {
            return System.getProperty(RECORD_CHECKSUM_PROP_NAME);
        }

        public static String replayChecksum() {
            return System.getProperty(REPLAY_CHECKSUM_PROP_NAME);
        }
    }
}

