/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import java.util.Arrays;

final class CatalogIndex {
    static final int DEFAULT_INDEX_SIZE = 10;
    static final long NULL_VALUE = -1L;
    private long[] index = new long[20];
    private int count;

    CatalogIndex() {
    }

    void add(long recordingId, long recordingDescriptorOffset) {
        CatalogIndex.ensurePositive(recordingId, "recordingId");
        CatalogIndex.ensurePositive(recordingDescriptorOffset, "recordingDescriptorOffset");
        int nextPosition = this.count << 1;
        long[] index = this.index;
        if (nextPosition > 0) {
            if (recordingId <= index[nextPosition - 2]) {
                throw new IllegalArgumentException(String.format("recordingId %d is less than or equal to the last recordingId %d", recordingId, index[nextPosition - 2]));
            }
            if (nextPosition == index.length) {
                this.index = index = CatalogIndex.expand(index);
            }
        }
        index[nextPosition] = recordingId;
        index[nextPosition + 1] = recordingDescriptorOffset;
        ++this.count;
    }

    long remove(long recordingId) {
        CatalogIndex.ensurePositive(recordingId, "recordingId");
        long[] index = this.index;
        int lastPosition = this.lastPosition();
        int position = CatalogIndex.find(index, recordingId, lastPosition);
        if (position < 0) {
            return -1L;
        }
        long recordingDescriptorOffset = index[position + 1];
        --this.count;
        for (int i = position; i < lastPosition; i += 2) {
            index[i] = index[i + 2];
            index[i + 1] = index[i + 3];
        }
        index[lastPosition] = 0L;
        index[lastPosition + 1] = 0L;
        return recordingDescriptorOffset;
    }

    long recordingOffset(long recordingId) {
        CatalogIndex.ensurePositive(recordingId, "recordingId");
        long[] index = this.index;
        int lastPosition = this.lastPosition();
        int position = CatalogIndex.find(index, recordingId, lastPosition);
        if (position < 0) {
            return -1L;
        }
        return index[position + 1];
    }

    int size() {
        return this.count;
    }

    int lastPosition() {
        return (this.count << 1) - 2;
    }

    long[] index() {
        return this.index;
    }

    static int find(long[] index, long recordingId, int lastPosition) {
        if (lastPosition > 0 && recordingId >= index[0] && recordingId <= index[lastPosition]) {
            int position = (int)((recordingId - index[0]) * (long)lastPosition / (index[lastPosition] - index[0]));
            int n = position = 0 == (position & 1) ? position : position + 1;
            if (recordingId == index[position]) {
                return position;
            }
            if (recordingId > index[position]) {
                for (int i = position + 2; i <= lastPosition; i += 2) {
                    long id = index[i];
                    if (recordingId == id) {
                        return i;
                    }
                    if (id <= recordingId) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = position - 2; i >= 0; i -= 2) {
                    long id = index[i];
                    if (recordingId == id) {
                        return i;
                    }
                    if (id >= recordingId) {
                        continue;
                    }
                    break;
                }
            }
        } else if (0 == lastPosition && recordingId == index[0]) {
            return 0;
        }
        return -1;
    }

    private static long[] expand(long[] index) {
        int length = index.length;
        int entries = length >> 1;
        int newLength = entries + (entries >> 1) << 1;
        return Arrays.copyOf(index, newLength);
    }

    private static void ensurePositive(long value, String msg) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format("%s cannot be negative, got %d", msg, value));
        }
    }
}

