/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Publication;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.RecordingProgressEncoder;
import io.aeron.archive.codecs.RecordingStartedEncoder;
import io.aeron.archive.codecs.RecordingStoppedEncoder;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

class RecordingEventsProxy
implements AutoCloseable {
    private static final int SEND_ATTEMPTS = 3;
    private final Publication publication;
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(1024);
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final RecordingStartedEncoder recordingStartedEncoder = new RecordingStartedEncoder();
    private final RecordingProgressEncoder recordingProgressEncoder = new RecordingProgressEncoder();
    private final RecordingStoppedEncoder recordingStoppedEncoder = new RecordingStoppedEncoder();

    RecordingEventsProxy(Publication publication) {
        this.publication = publication;
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.publication);
    }

    void started(long recordingId, long startPosition, int sessionId, int streamId, String channel, String sourceIdentity) {
        long result;
        this.recordingStartedEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).recordingId(recordingId).startPosition(startPosition).sessionId(sessionId).streamId(streamId).channel(channel).sourceIdentity(sourceIdentity);
        int attempts = 3;
        while ((result = this.publication.offer((DirectBuffer)this.buffer, 0, this.recordingStartedEncoder.encodedLength())) <= 0L && -1L != result) {
            RecordingEventsProxy.checkResult(result);
            if (--attempts > 0) continue;
        }
    }

    boolean progress(long recordingId, long startPosition, long position) {
        int length = 32;
        long result = this.publication.tryClaim(32, this.bufferClaim);
        if (result > 0L) {
            this.recordingProgressEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).recordingId(recordingId).startPosition(startPosition).position(position);
            this.bufferClaim.commit();
            return true;
        }
        RecordingEventsProxy.checkResult(result);
        return false;
    }

    void stopped(long recordingId, long startPosition, long stopPosition) {
        int length = 32;
        int attempts = 3;
        do {
            long result;
            if ((result = this.publication.tryClaim(32, this.bufferClaim)) > 0L) {
                this.recordingStoppedEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).recordingId(recordingId).startPosition(startPosition).stopPosition(stopPosition);
                this.bufferClaim.commit();
                break;
            }
            if (-1L == result) break;
            RecordingEventsProxy.checkResult(result);
        } while (--attempts > 0);
    }

    private static void checkResult(long result) {
        if (result == -4L) {
            throw new ArchiveException("recording events publication is closed");
        }
        if (result == -5L) {
            throw new ArchiveException("recording events publication at max position");
        }
    }
}

