/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Counter;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.Archive;
import io.aeron.archive.ControlSession;
import io.aeron.archive.RecordingEventsProxy;
import io.aeron.archive.RecordingWriter;
import io.aeron.archive.Session;
import io.aeron.archive.checksum.Checksum;
import io.aeron.logbuffer.BlockHandler;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.UnsafeBuffer;

class RecordingSession
implements Session {
    private final long correlationId;
    private final long recordingId;
    private long progressEventPosition;
    private final int blockLengthLimit;
    private final boolean autoStop;
    private final RecordingEventsProxy recordingEventsProxy;
    private final Image image;
    private final Counter position;
    private final RecordingWriter recordingWriter;
    private State state = State.INIT;
    private final String originalChannel;
    private final ControlSession controlSession;
    private final CountedErrorHandler countedErrorHandler;

    RecordingSession(long correlationId, long recordingId, long startPosition, int segmentLength, String originalChannel, RecordingEventsProxy recordingEventsProxy, Image image, Counter position, FileChannel archiveDirChannel, Archive.Context ctx, ControlSession controlSession, UnsafeBuffer checksumBuffer, Checksum checksum, boolean autoStop) {
        this.correlationId = correlationId;
        this.recordingId = recordingId;
        this.originalChannel = originalChannel;
        this.recordingEventsProxy = recordingEventsProxy;
        this.image = image;
        this.position = position;
        this.controlSession = controlSession;
        this.autoStop = autoStop;
        this.countedErrorHandler = ctx.countedErrorHandler();
        this.progressEventPosition = image.joinPosition();
        this.blockLengthLimit = Math.min(image.termBufferLength(), ctx.fileIoMaxLength());
        this.recordingWriter = new RecordingWriter(recordingId, startPosition, segmentLength, image, ctx, archiveDirChannel, checksumBuffer, checksum);
    }

    public long correlationId() {
        return this.correlationId;
    }

    @Override
    public long sessionId() {
        return this.recordingId;
    }

    @Override
    public boolean isDone() {
        return this.state == State.STOPPED;
    }

    @Override
    public void abort() {
        this.state(State.INACTIVE);
    }

    @Override
    public void close() {
        if (this.autoStop) {
            Subscription subscription = this.image.subscription();
            CloseHelper.close((ErrorHandler)this.countedErrorHandler, (AutoCloseable)subscription);
            this.controlSession.archiveConductor().removeRecordingSubscription(subscription.registrationId());
        }
        CloseHelper.close((ErrorHandler)this.countedErrorHandler, (AutoCloseable)this.position);
        this.recordingWriter.close();
    }

    public void abortClose() {
        this.recordingWriter.close();
    }

    public Counter recordingPosition() {
        return this.position;
    }

    public long recordedPosition() {
        if (this.position.isClosed()) {
            return -1L;
        }
        return this.position.get();
    }

    @Override
    public int doWork() {
        int workCount = 0;
        if (State.INIT == this.state) {
            workCount += this.init();
        }
        if (State.RECORDING == this.state) {
            workCount += this.record();
        }
        if (State.INACTIVE == this.state) {
            this.state(State.STOPPED);
            if (null != this.recordingEventsProxy) {
                this.recordingEventsProxy.stopped(this.recordingId, this.image.joinPosition(), this.position.getWeak());
            }
            this.recordingWriter.close();
            ++workCount;
        }
        return workCount;
    }

    Subscription subscription() {
        return this.image.subscription();
    }

    ControlSession controlSession() {
        return this.controlSession;
    }

    private int init() {
        try {
            this.recordingWriter.init();
        }
        catch (IOException ex) {
            this.recordingWriter.close();
            this.state(State.STOPPED);
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        if (null != this.recordingEventsProxy) {
            this.recordingEventsProxy.started(this.recordingId, this.image.joinPosition(), this.image.sessionId(), this.image.subscription().streamId(), this.originalChannel, this.image.sourceIdentity());
        }
        this.state(State.RECORDING);
        return 1;
    }

    private int record() {
        int workCount = 0;
        try {
            long recordedPosition;
            workCount = this.image.blockPoll((BlockHandler)this.recordingWriter, this.blockLengthLimit);
            if (this.recordingWriter.isClosed()) {
                this.state(State.INACTIVE);
                return workCount;
            }
            if (workCount > 0) {
                this.position.setOrdered(this.recordingWriter.position());
            } else if (this.image.isEndOfStream() || this.image.isClosed()) {
                this.state(State.INACTIVE);
            }
            if (null != this.recordingEventsProxy && this.progressEventPosition < (recordedPosition = this.recordingWriter.position()) && this.recordingEventsProxy.progress(this.recordingId, this.image.joinPosition(), recordedPosition)) {
                this.progressEventPosition = recordedPosition;
            }
        }
        catch (Exception ex) {
            this.state(State.INACTIVE);
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return workCount;
    }

    private void state(State newState) {
        this.state = newState;
    }

    private static enum State {
        INIT,
        RECORDING,
        INACTIVE,
        STOPPED;

    }
}

