/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Session;
import java.util.ArrayList;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.Agent;

class SessionWorker<T extends Session>
implements Agent {
    private final ArrayList<T> sessions = new ArrayList();
    private final String roleName;
    protected final ErrorHandler errorHandler;
    private boolean isClosed = false;

    SessionWorker(String roleName, ErrorHandler errorHandler) {
        this.roleName = roleName;
        this.errorHandler = errorHandler;
    }

    public String roleName() {
        return this.roleName;
    }

    public int doWork() {
        int lastIndex;
        int workCount = 0;
        ArrayList<T> sessions = this.sessions;
        for (int i = lastIndex = sessions.size() - 1; i >= 0; --i) {
            Session session = (Session)sessions.get(i);
            try {
                workCount += session.doWork();
            }
            catch (Exception ex) {
                this.errorHandler.onError((Throwable)ex);
            }
            if (!session.isDone()) continue;
            ArrayListUtil.fastUnorderedRemove(sessions, (int)i, (int)lastIndex--);
            this.closeSession(session);
        }
        return workCount;
    }

    public final void onClose() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.preSessionsClose();
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
        int size = this.sessions.size();
        for (int i = 0; i < size; ++i) {
            this.closeSession((Session)this.sessions.get(i));
        }
        this.postSessionsClose();
    }

    protected void abort() {
    }

    protected void closeSession(T session) {
        try {
            session.close();
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
    }

    protected void postSessionsClose() {
    }

    protected void preSessionsClose() {
    }

    protected void addSession(T session) {
        this.sessions.add(session);
    }
}

