/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.Subscription;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.RecordingEventsListener;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingProgressDecoder;
import io.aeron.archive.codecs.RecordingStartedDecoder;
import io.aeron.archive.codecs.RecordingStoppedDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class RecordingEventsAdapter
implements FragmentHandler {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final RecordingStartedDecoder recordingStartedDecoder = new RecordingStartedDecoder();
    private final RecordingProgressDecoder recordingProgressDecoder = new RecordingProgressDecoder();
    private final RecordingStoppedDecoder recordingStoppedDecoder = new RecordingStoppedDecoder();
    private final int fragmentLimit;
    private final RecordingEventsListener listener;
    private final Subscription subscription;

    public RecordingEventsAdapter(RecordingEventsListener listener, Subscription subscription, int fragmentLimit) {
        this.fragmentLimit = fragmentLimit;
        this.listener = listener;
        this.subscription = subscription;
    }

    public int poll() {
        return this.subscription.poll((FragmentHandler)this, this.fragmentLimit);
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        switch (this.messageHeaderDecoder.templateId()) {
            case 101: {
                this.recordingStartedDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.listener.onStart(this.recordingStartedDecoder.recordingId(), this.recordingStartedDecoder.startPosition(), this.recordingStartedDecoder.sessionId(), this.recordingStartedDecoder.streamId(), this.recordingStartedDecoder.channel(), this.recordingStartedDecoder.sourceIdentity());
                break;
            }
            case 102: {
                this.recordingProgressDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.listener.onProgress(this.recordingProgressDecoder.recordingId(), this.recordingProgressDecoder.startPosition(), this.recordingProgressDecoder.position());
                break;
            }
            case 103: {
                this.recordingStoppedDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.listener.onStop(this.recordingStoppedDecoder.recordingId(), this.recordingStoppedDecoder.startPosition(), this.recordingStoppedDecoder.stopPosition());
            }
        }
    }
}

