/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.MetaAttribute;
import io.aeron.archive.codecs.RecordingProgressDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class RecordingProgressEncoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 102;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordingProgressEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 102;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RecordingProgressEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 24);
        return this;
    }

    public RecordingProgressEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(24).templateId(102).schemaId(101).version(5);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int recordingIdId() {
        return 1;
    }

    public static int recordingIdSinceVersion() {
        return 0;
    }

    public static int recordingIdEncodingOffset() {
        return 0;
    }

    public static int recordingIdEncodingLength() {
        return 8;
    }

    public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long recordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long recordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingProgressEncoder recordingId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int startPositionId() {
        return 2;
    }

    public static int startPositionSinceVersion() {
        return 0;
    }

    public static int startPositionEncodingOffset() {
        return 8;
    }

    public static int startPositionEncodingLength() {
        return 8;
    }

    public static String startPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long startPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long startPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingProgressEncoder startPosition(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int positionId() {
        return 3;
    }

    public static int positionSinceVersion() {
        return 0;
    }

    public static int positionEncodingOffset() {
        return 16;
    }

    public static int positionEncodingLength() {
        return 8;
    }

    public static String positionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long positionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long positionMinValue() {
        return -9223372036854775807L;
    }

    public static long positionMaxValue() {
        return Long.MAX_VALUE;
    }

    public RecordingProgressEncoder position(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        RecordingProgressDecoder decoder = new RecordingProgressDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 24, 5);
        return decoder.appendTo(builder);
    }
}

