/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.RecordingSession;
import io.aeron.archive.ReplaySession;
import io.aeron.archive.Session;
import io.aeron.archive.SessionWorker;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;
import org.agrona.concurrent.status.AtomicCounter;

final class DedicatedModeArchiveConductor
extends ArchiveConductor {
    private static final int COMMAND_LIMIT = 10;
    private final ManyToOneConcurrentLinkedQueue<Session> closeQueue = new ManyToOneConcurrentLinkedQueue();
    private AgentRunner recorderAgentRunner;
    private AgentRunner replayerAgentRunner;

    DedicatedModeArchiveConductor(Archive.Context ctx) {
        super(ctx);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.recorderAgentRunner = new AgentRunner(this.ctx.recorderIdleStrategy(), (ErrorHandler)this.errorHandler, this.ctx.errorCounter(), (Agent)this.recorder);
        this.replayerAgentRunner = new AgentRunner(this.ctx.replayerIdleStrategy(), (ErrorHandler)this.errorHandler, this.ctx.errorCounter(), (Agent)this.replayer);
        AgentRunner.startOnThread((AgentRunner)this.recorderAgentRunner, (ThreadFactory)this.ctx.threadFactory());
        AgentRunner.startOnThread((AgentRunner)this.replayerAgentRunner, (ThreadFactory)this.ctx.threadFactory());
    }

    @Override
    public int doWork() {
        return this.processCloseQueue() + super.doWork();
    }

    @Override
    protected void closeSessionWorkers() {
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.recorderAgentRunner);
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.replayerAgentRunner);
        while (this.processCloseQueue() > 0 || !this.closeQueue.isEmpty()) {
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
    }

    @Override
    SessionWorker<RecordingSession> newRecorder() {
        return new DedicatedModeRecorder(this.errorHandler, this.ctx.errorCounter(), this.closeQueue, this.ctx.abortLatch());
    }

    @Override
    SessionWorker<ReplaySession> newReplayer() {
        return new DedicatedModeReplayer(this.errorHandler, this.ctx.errorCounter(), this.closeQueue, this.ctx.abortLatch());
    }

    private int processCloseQueue() {
        Session session;
        int i;
        for (i = 0; i < 10 && (session = (Session)this.closeQueue.poll()) != null; ++i) {
            if (session instanceof RecordingSession) {
                this.closeRecordingSession((RecordingSession)session);
                continue;
            }
            if (session instanceof ReplaySession) {
                this.closeReplaySession((ReplaySession)session);
                continue;
            }
            this.closeSession(session);
        }
        return i;
    }

    static class DedicatedModeReplayer
    extends SessionWorker<ReplaySession> {
        private final ManyToOneConcurrentLinkedQueue<ReplaySession> sessionsQueue;
        private final ManyToOneConcurrentLinkedQueue<Session> closeQueue;
        private final AtomicCounter errorCounter;
        private final CountDownLatch abortLatch;
        private volatile boolean isAbort;

        DedicatedModeReplayer(CountedErrorHandler errorHandler, AtomicCounter errorCounter, ManyToOneConcurrentLinkedQueue<Session> closeQueue, CountDownLatch abortLatch) {
            super("archive-replayer", errorHandler);
            this.closeQueue = closeQueue;
            this.errorCounter = errorCounter;
            this.sessionsQueue = new ManyToOneConcurrentLinkedQueue();
            this.abortLatch = abortLatch;
        }

        @Override
        protected void abort() {
            this.isAbort = true;
        }

        @Override
        protected void addSession(ReplaySession session) {
            this.send(session);
        }

        @Override
        public int doWork() {
            if (this.isAbort) {
                throw new AgentTerminationException();
            }
            return this.drainSessionQueue() + super.doWork();
        }

        @Override
        protected void preSessionsClose() {
            this.drainSessionQueue();
        }

        @Override
        protected void closeSession(ReplaySession session) {
            while (!this.closeQueue.offer((Object)session)) {
                if (!this.errorCounter.isClosed()) {
                    this.errorCounter.increment();
                }
                Thread.yield();
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }

        @Override
        protected void postSessionsClose() {
            if (this.isAbort) {
                this.abortLatch.countDown();
            }
        }

        private int drainSessionQueue() {
            ReplaySession session;
            int workCount = 0;
            while (null != (session = (ReplaySession)this.sessionsQueue.poll())) {
                ++workCount;
                super.addSession(session);
            }
            return workCount;
        }

        private void send(ReplaySession session) {
            while (!this.sessionsQueue.offer((Object)session)) {
                if (!this.errorCounter.isClosed()) {
                    this.errorCounter.increment();
                }
                Thread.yield();
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
    }

    static class DedicatedModeRecorder
    extends SessionWorker<RecordingSession> {
        private final ManyToOneConcurrentLinkedQueue<RecordingSession> sessionsQueue;
        private final ManyToOneConcurrentLinkedQueue<Session> closeQueue;
        private final AtomicCounter errorCounter;
        private final CountDownLatch abortLatch;
        private volatile boolean isAbort;

        DedicatedModeRecorder(CountedErrorHandler errorHandler, AtomicCounter errorCounter, ManyToOneConcurrentLinkedQueue<Session> closeQueue, CountDownLatch abortLatch) {
            super("archive-recorder", errorHandler);
            this.closeQueue = closeQueue;
            this.errorCounter = errorCounter;
            this.sessionsQueue = new ManyToOneConcurrentLinkedQueue();
            this.abortLatch = abortLatch;
        }

        @Override
        protected void abort() {
            this.isAbort = true;
        }

        @Override
        public int doWork() {
            if (this.isAbort) {
                throw new AgentTerminationException();
            }
            return this.drainSessionsQueue() + super.doWork();
        }

        @Override
        protected void preSessionsClose() {
            this.drainSessionsQueue();
        }

        @Override
        protected void addSession(RecordingSession session) {
            this.send(session);
        }

        @Override
        protected void closeSession(RecordingSession session) {
            while (!this.closeQueue.offer((Object)session)) {
                if (!this.errorCounter.isClosed()) {
                    this.errorCounter.increment();
                }
                Thread.yield();
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }

        @Override
        protected void postSessionsClose() {
            if (this.isAbort) {
                this.abortLatch.countDown();
            }
        }

        private int drainSessionsQueue() {
            RecordingSession session;
            int workCount = 0;
            while (null != (session = (RecordingSession)this.sessionsQueue.poll())) {
                ++workCount;
                super.addSession(session);
            }
            return workCount;
        }

        private void send(RecordingSession session) {
            while (!this.sessionsQueue.offer((Object)session)) {
                if (!this.errorCounter.isClosed()) {
                    this.errorCounter.increment();
                }
                Thread.yield();
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
    }
}

