/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Counter;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.Archive;
import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.ControlSession;
import io.aeron.archive.RecordingEventsProxy;
import io.aeron.archive.RecordingWriter;
import io.aeron.archive.Session;
import io.aeron.archive.client.ArchiveException;
import io.aeron.logbuffer.BlockHandler;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.CountedErrorHandler;

class RecordingSession
implements Session {
    private final boolean isAutoStop;
    private volatile boolean isAborted = false;
    private final long correlationId;
    private final long recordingId;
    private long progressEventPosition;
    private final int blockLengthLimit;
    private final RecordingEventsProxy recordingEventsProxy;
    private final Image image;
    private final Counter position;
    private final RecordingWriter recordingWriter;
    private final String originalChannel;
    private final ControlSession controlSession;
    private final CountedErrorHandler countedErrorHandler;
    private State state = State.INIT;
    private String errorMessage = null;
    private int errorCode = 0;

    RecordingSession(long correlationId, long recordingId, long startPosition, int segmentLength, String originalChannel, RecordingEventsProxy recordingEventsProxy, Image image, Counter position, Archive.Context ctx, ControlSession controlSession, boolean isAutoStop) {
        this.correlationId = correlationId;
        this.recordingId = recordingId;
        this.originalChannel = originalChannel;
        this.recordingEventsProxy = recordingEventsProxy;
        this.image = image;
        this.position = position;
        this.controlSession = controlSession;
        this.isAutoStop = isAutoStop;
        this.countedErrorHandler = ctx.countedErrorHandler();
        this.progressEventPosition = image.joinPosition();
        this.blockLengthLimit = Math.min(image.termBufferLength(), ctx.fileIoMaxLength());
        this.recordingWriter = new RecordingWriter(recordingId, startPosition, segmentLength, image, ctx);
    }

    @Override
    public long sessionId() {
        return this.recordingId;
    }

    @Override
    public boolean isDone() {
        return this.state == State.STOPPED;
    }

    @Override
    public void abort() {
        this.isAborted = true;
    }

    @Override
    public void close() {
        this.recordingWriter.close();
        CloseHelper.close((ErrorHandler)this.countedErrorHandler, (AutoCloseable)this.position);
    }

    @Override
    public int doWork() {
        int workCount = 0;
        if (this.isAborted) {
            this.state = State.INACTIVE;
        }
        if (State.INIT == this.state) {
            workCount += this.init();
        }
        if (State.RECORDING == this.state) {
            workCount += this.record();
        }
        if (State.INACTIVE == this.state) {
            this.recordingWriter.close();
            this.state(State.STOPPED);
            ++workCount;
            if (null != this.recordingEventsProxy) {
                this.recordingEventsProxy.stopped(this.recordingId, this.image.joinPosition(), this.position.getWeak());
            }
        }
        return workCount;
    }

    void abortClose() {
        this.recordingWriter.close();
    }

    long correlationId() {
        return this.correlationId;
    }

    Counter recordingPosition() {
        return this.position;
    }

    long recordedPosition() {
        if (this.position.isClosed()) {
            return -1L;
        }
        return this.position.get();
    }

    Subscription subscription() {
        return this.image.subscription();
    }

    ControlSession controlSession() {
        return this.controlSession;
    }

    boolean isAutoStop() {
        return this.isAutoStop;
    }

    void sendPendingError(ControlResponseProxy controlResponseProxy) {
        if (null != this.errorMessage && !this.controlSession.isDone()) {
            this.controlSession.attemptErrorResponse(this.correlationId, this.errorCode, this.errorMessage, controlResponseProxy);
        }
    }

    private int init() {
        try {
            this.recordingWriter.init();
        }
        catch (Throwable ex) {
            this.errorMessage = ex.getClass().getName() + ": " + ex.getMessage();
            this.recordingWriter.close();
            this.state(State.STOPPED);
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        if (null != this.recordingEventsProxy) {
            this.recordingEventsProxy.started(this.recordingId, this.image.joinPosition(), this.image.sessionId(), this.image.subscription().streamId(), this.originalChannel, this.image.sourceIdentity());
        }
        this.state(State.RECORDING);
        return 1;
    }

    private int record() {
        try {
            long recordedPosition;
            int workCount = this.image.blockPoll((BlockHandler)this.recordingWriter, this.blockLengthLimit);
            if (workCount > 0) {
                this.position.setOrdered(this.recordingWriter.position());
            } else if (this.image.isEndOfStream() || this.image.isClosed()) {
                this.state(State.INACTIVE);
            }
            if (null != this.recordingEventsProxy && this.progressEventPosition < (recordedPosition = this.recordingWriter.position()) && this.recordingEventsProxy.progress(this.recordingId, this.image.joinPosition(), recordedPosition)) {
                this.progressEventPosition = recordedPosition;
            }
            return workCount;
        }
        catch (ArchiveException ex) {
            this.countedErrorHandler.onError((Throwable)((Object)ex));
            this.errorMessage = ex.getMessage();
            this.errorCode = ex.errorCode();
            this.state(State.INACTIVE);
        }
        catch (Throwable ex) {
            this.countedErrorHandler.onError(ex);
            this.errorMessage = ex.getClass().getName() + ": " + ex.getMessage();
            this.state(State.INACTIVE);
        }
        return 1;
    }

    private void state(State newState) {
        this.state = newState;
    }

    static enum State {
        INIT,
        RECORDING,
        INACTIVE,
        STOPPED;

    }
}

