/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;

public final class RecordingDescriptorPoller {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final RecordingDescriptorDecoder recordingDescriptorDecoder = new RecordingDescriptorDecoder();
    private final long controlSessionId;
    private final int fragmentLimit;
    private final Subscription subscription;
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this::onFragment);
    private final ErrorHandler errorHandler;
    private long correlationId;
    private int remainingRecordCount;
    private boolean isDispatchComplete = false;
    private RecordingDescriptorConsumer consumer;

    public RecordingDescriptorPoller(Subscription subscription, ErrorHandler errorHandler, long controlSessionId, int fragmentLimit) {
        this.subscription = subscription;
        this.errorHandler = errorHandler;
        this.fragmentLimit = fragmentLimit;
        this.controlSessionId = controlSessionId;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public int poll() {
        this.isDispatchComplete = false;
        return this.subscription.controlledPoll((ControlledFragmentHandler)this.fragmentAssembler, this.fragmentLimit);
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public boolean isDispatchComplete() {
        return this.isDispatchComplete;
    }

    public int remainingRecordCount() {
        return this.remainingRecordCount;
    }

    public void reset(long correlationId, int recordCount, RecordingDescriptorConsumer consumer) {
        this.correlationId = correlationId;
        this.consumer = consumer;
        this.remainingRecordCount = recordCount;
        this.isDispatchComplete = false;
    }

    ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        if (this.isDispatchComplete) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        switch (templateId) {
            case 1: {
                this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                if (this.controlResponseDecoder.controlSessionId() != this.controlSessionId) break;
                ControlResponseCode code = this.controlResponseDecoder.code();
                long correlationId = this.controlResponseDecoder.correlationId();
                if (ControlResponseCode.RECORDING_UNKNOWN == code && correlationId == this.correlationId) {
                    this.isDispatchComplete = true;
                    return ControlledFragmentHandler.Action.BREAK;
                }
                if (ControlResponseCode.ERROR != code) break;
                ArchiveException ex = new ArchiveException("response for correlationId=" + this.correlationId + ", error: " + this.controlResponseDecoder.errorMessage(), (int)this.controlResponseDecoder.relevantId(), correlationId);
                if (correlationId == this.correlationId) {
                    throw ex;
                }
                if (null == this.errorHandler) break;
                this.errorHandler.onError((Throwable)((Object)ex));
                break;
            }
            case 22: {
                this.recordingDescriptorDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long correlationId = this.recordingDescriptorDecoder.correlationId();
                if (this.recordingDescriptorDecoder.controlSessionId() != this.controlSessionId || correlationId != this.correlationId) break;
                this.consumer.onRecordingDescriptor(this.controlSessionId, correlationId, this.recordingDescriptorDecoder.recordingId(), this.recordingDescriptorDecoder.startTimestamp(), this.recordingDescriptorDecoder.stopTimestamp(), this.recordingDescriptorDecoder.startPosition(), this.recordingDescriptorDecoder.stopPosition(), this.recordingDescriptorDecoder.initialTermId(), this.recordingDescriptorDecoder.segmentFileLength(), this.recordingDescriptorDecoder.termBufferLength(), this.recordingDescriptorDecoder.mtuLength(), this.recordingDescriptorDecoder.sessionId(), this.recordingDescriptorDecoder.streamId(), this.recordingDescriptorDecoder.strippedChannel(), this.recordingDescriptorDecoder.originalChannel(), this.recordingDescriptorDecoder.sourceIdentity());
                if (0 != --this.remainingRecordCount) break;
                this.isDispatchComplete = true;
                return ControlledFragmentHandler.Action.BREAK;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public String toString() {
        return "RecordingDescriptorPoller{controlSessionId=" + this.controlSessionId + ", correlationId=" + this.correlationId + ", remainingRecordCount=" + this.remainingRecordCount + ", isDispatchComplete=" + this.isDispatchComplete + '}';
    }
}

