/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.archive.codecs.RecordingSignalEventDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.SemanticVersion;

public final class RecordingSignalPoller {
    public static final int FRAGMENT_LIMIT = 10;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final RecordingSignalEventDecoder recordingSignalEventDecoder = new RecordingSignalEventDecoder();
    private final Subscription subscription;
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this::onFragment);
    private final long controlSessionId;
    private long correlationId = -1L;
    private long relevantId = -1L;
    private int templateId = -1;
    private int version = 0;
    private long recordingId = -1L;
    private long recordingSubscriptionId = -1L;
    private long recordingPosition = -1L;
    private RecordingSignal recordingSignal = null;
    private ControlResponseCode code;
    private String errorMessage;
    private final int fragmentLimit;
    private boolean isPollComplete = false;

    private RecordingSignalPoller(long controlSessionId, Subscription subscription, int fragmentLimit) {
        this.controlSessionId = controlSessionId;
        this.subscription = subscription;
        this.fragmentLimit = fragmentLimit;
    }

    public RecordingSignalPoller(long controlSessionId, Subscription subscription) {
        this(controlSessionId, subscription, 10);
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public int poll() {
        this.templateId = -1;
        this.correlationId = -1L;
        this.relevantId = -1L;
        this.version = 0;
        this.errorMessage = null;
        this.recordingId = -1L;
        this.recordingSubscriptionId = -1L;
        this.recordingPosition = -1L;
        this.recordingSignal = null;
        this.isPollComplete = false;
        return this.subscription.controlledPoll((ControlledFragmentHandler)this.fragmentAssembler, this.fragmentLimit);
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public long relevantId() {
        return this.relevantId;
    }

    public int templateId() {
        return this.templateId;
    }

    public long recordingId() {
        return this.recordingId;
    }

    public long recordingSubscriptionId() {
        return this.recordingSubscriptionId;
    }

    public long recordingPosition() {
        return this.recordingPosition;
    }

    public RecordingSignal recordingSignal() {
        return this.recordingSignal;
    }

    public int version() {
        return this.version;
    }

    public boolean isPollComplete() {
        return this.isPollComplete;
    }

    public ControlResponseCode code() {
        return this.code;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        if (this.isPollComplete) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (1 == templateId) {
            this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            if (this.controlResponseDecoder.controlSessionId() == this.controlSessionId) {
                this.templateId = templateId;
                this.correlationId = this.controlResponseDecoder.correlationId();
                this.relevantId = this.controlResponseDecoder.relevantId();
                this.code = this.controlResponseDecoder.code();
                this.version = this.controlResponseDecoder.version();
                this.errorMessage = this.controlResponseDecoder.errorMessage();
                this.isPollComplete = true;
                return ControlledFragmentHandler.Action.BREAK;
            }
        } else if (24 == templateId) {
            this.recordingSignalEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            if (this.recordingSignalEventDecoder.controlSessionId() == this.controlSessionId) {
                this.templateId = templateId;
                this.correlationId = this.recordingSignalEventDecoder.correlationId();
                this.recordingId = this.recordingSignalEventDecoder.recordingId();
                this.recordingSubscriptionId = this.recordingSignalEventDecoder.subscriptionId();
                this.recordingPosition = this.recordingSignalEventDecoder.position();
                this.recordingSignal = this.recordingSignalEventDecoder.signal();
                this.isPollComplete = true;
                return ControlledFragmentHandler.Action.BREAK;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public String toString() {
        return "RecordingSignalPoller{controlSessionId=" + this.controlSessionId + ", correlationId=" + this.correlationId + ", relevantId=" + this.relevantId + ", code=" + (Object)((Object)this.code) + ", templateId=" + this.templateId + ", version=" + SemanticVersion.toString((int)this.version) + ", errorMessage='" + this.errorMessage + '\'' + ", recordingId=" + this.recordingId + ", recordingSubscriptionId=" + this.recordingSubscriptionId + ", recordingPosition=" + this.recordingPosition + ", recordingSignal=" + (Object)((Object)this.recordingSignal) + ", isPollComplete=" + this.isPollComplete + '}';
    }
}

