/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class CatalogHeaderDecoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 20;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 6;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final CatalogHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 20;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public CatalogHeaderDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public CatalogHeaderDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (20 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public CatalogHeaderDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int versionId() {
        return 1;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 0;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int version() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int lengthId() {
        return 2;
    }

    public static int lengthSinceVersion() {
        return 0;
    }

    public static int lengthEncodingOffset() {
        return 4;
    }

    public static int lengthEncodingLength() {
        return 4;
    }

    public static String lengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int lengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lengthMinValue() {
        return -2147483647;
    }

    public static int lengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int length() {
        return this.buffer.getInt(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int nextRecordingIdId() {
        return 3;
    }

    public static int nextRecordingIdSinceVersion() {
        return 0;
    }

    public static int nextRecordingIdEncodingOffset() {
        return 8;
    }

    public static int nextRecordingIdEncodingLength() {
        return 8;
    }

    public static String nextRecordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long nextRecordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long nextRecordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long nextRecordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long nextRecordingId() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int alignmentId() {
        return 4;
    }

    public static int alignmentSinceVersion() {
        return 0;
    }

    public static int alignmentEncodingOffset() {
        return 16;
    }

    public static int alignmentEncodingLength() {
        return 4;
    }

    public static String alignmentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int alignmentNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int alignmentMinValue() {
        return -2147483647;
    }

    public static int alignmentMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int alignment() {
        return this.buffer.getInt(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int reservedId() {
        return 5;
    }

    public static int reservedSinceVersion() {
        return 0;
    }

    public static int reservedEncodingOffset() {
        return 31;
    }

    public static int reservedEncodingLength() {
        return 1;
    }

    public static String reservedMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte reservedNullValue() {
        return -128;
    }

    public static byte reservedMinValue() {
        return -127;
    }

    public static byte reservedMaxValue() {
        return 127;
    }

    public byte reserved() {
        return this.buffer.getByte(this.offset + 31);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        CatalogHeaderDecoder decoder = new CatalogHeaderDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[CatalogHeader](sbeTemplateId=");
        builder.append(20);
        builder.append("|sbeSchemaId=");
        builder.append(101);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 6) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(6);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 32) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(32);
        builder.append("):");
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("length=");
        builder.append(this.length());
        builder.append('|');
        builder.append("nextRecordingId=");
        builder.append(this.nextRecordingId());
        builder.append('|');
        builder.append("alignment=");
        builder.append(this.alignment());
        builder.append('|');
        builder.append("reserved=");
        builder.append(this.reserved());
        this.limit(originalLimit);
        return builder;
    }
}

