/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.MetaAttribute;
import io.aeron.archive.codecs.RecordingSignal;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class RecordingSignalEventDecoder {
    public static final int BLOCK_LENGTH = 44;
    public static final int TEMPLATE_ID = 24;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 6;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RecordingSignalEventDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 44;
    }

    public int sbeTemplateId() {
        return 24;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public RecordingSignalEventDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public RecordingSignalEventDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (24 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public RecordingSignalEventDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long controlSessionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int recordingIdId() {
        return 3;
    }

    public static int recordingIdSinceVersion() {
        return 0;
    }

    public static int recordingIdEncodingOffset() {
        return 16;
    }

    public static int recordingIdEncodingLength() {
        return 8;
    }

    public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long recordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long recordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long recordingId() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int subscriptionIdId() {
        return 4;
    }

    public static int subscriptionIdSinceVersion() {
        return 0;
    }

    public static int subscriptionIdEncodingOffset() {
        return 24;
    }

    public static int subscriptionIdEncodingLength() {
        return 8;
    }

    public static String subscriptionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long subscriptionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long subscriptionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long subscriptionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long subscriptionId() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int positionId() {
        return 5;
    }

    public static int positionSinceVersion() {
        return 0;
    }

    public static int positionEncodingOffset() {
        return 32;
    }

    public static int positionEncodingLength() {
        return 8;
    }

    public static String positionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long positionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long positionMinValue() {
        return -9223372036854775807L;
    }

    public static long positionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long position() {
        return this.buffer.getLong(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static int signalId() {
        return 6;
    }

    public static int signalSinceVersion() {
        return 0;
    }

    public static int signalEncodingOffset() {
        return 40;
    }

    public static int signalEncodingLength() {
        return 4;
    }

    public static String signalMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int signalRaw() {
        return this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN);
    }

    public RecordingSignal signal() {
        return RecordingSignal.get(this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        RecordingSignalEventDecoder decoder = new RecordingSignalEventDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[RecordingSignalEvent](sbeTemplateId=");
        builder.append(24);
        builder.append("|sbeSchemaId=");
        builder.append(101);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 6) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(6);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 44) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(44);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("recordingId=");
        builder.append(this.recordingId());
        builder.append('|');
        builder.append("subscriptionId=");
        builder.append(this.subscriptionId());
        builder.append('|');
        builder.append("position=");
        builder.append(this.position());
        builder.append('|');
        builder.append("signal=");
        builder.append((Object)this.signal());
        this.limit(originalLimit);
        return builder;
    }
}

