/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs.mark;

import io.aeron.archive.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.archive.codecs.mark.MessageHeaderEncoder;
import io.aeron.archive.codecs.mark.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class MarkFileHeaderEncoder {
    public static final int BLOCK_LENGTH = 128;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 100;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final MarkFileHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 128;
    }

    public int sbeTemplateId() {
        return 200;
    }

    public int sbeSchemaId() {
        return 100;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public MarkFileHeaderEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 128);
        return this;
    }

    public MarkFileHeaderEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(128).templateId(200).schemaId(100).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int versionId() {
        return 1;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 0;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder version(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int activityTimestampId() {
        return 2;
    }

    public static int activityTimestampSinceVersion() {
        return 0;
    }

    public static int activityTimestampEncodingOffset() {
        return 8;
    }

    public static int activityTimestampEncodingLength() {
        return 8;
    }

    public static String activityTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long activityTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long activityTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long activityTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public MarkFileHeaderEncoder activityTimestamp(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int startTimestampId() {
        return 3;
    }

    public static int startTimestampSinceVersion() {
        return 0;
    }

    public static int startTimestampEncodingOffset() {
        return 16;
    }

    public static int startTimestampEncodingLength() {
        return 8;
    }

    public static String startTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long startTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public MarkFileHeaderEncoder startTimestamp(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int pidId() {
        return 4;
    }

    public static int pidSinceVersion() {
        return 0;
    }

    public static int pidEncodingOffset() {
        return 24;
    }

    public static int pidEncodingLength() {
        return 8;
    }

    public static String pidMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long pidNullValue() {
        return Long.MIN_VALUE;
    }

    public static long pidMinValue() {
        return -9223372036854775807L;
    }

    public static long pidMaxValue() {
        return Long.MAX_VALUE;
    }

    public MarkFileHeaderEncoder pid(long value) {
        this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int controlStreamIdId() {
        return 5;
    }

    public static int controlStreamIdSinceVersion() {
        return 0;
    }

    public static int controlStreamIdEncodingOffset() {
        return 32;
    }

    public static int controlStreamIdEncodingLength() {
        return 4;
    }

    public static String controlStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int controlStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int controlStreamIdMinValue() {
        return -2147483647;
    }

    public static int controlStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder controlStreamId(int value) {
        this.buffer.putInt(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int localControlStreamIdId() {
        return 6;
    }

    public static int localControlStreamIdSinceVersion() {
        return 0;
    }

    public static int localControlStreamIdEncodingOffset() {
        return 36;
    }

    public static int localControlStreamIdEncodingLength() {
        return 4;
    }

    public static String localControlStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int localControlStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int localControlStreamIdMinValue() {
        return -2147483647;
    }

    public static int localControlStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder localControlStreamId(int value) {
        this.buffer.putInt(this.offset + 36, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int eventsStreamIdId() {
        return 7;
    }

    public static int eventsStreamIdSinceVersion() {
        return 0;
    }

    public static int eventsStreamIdEncodingOffset() {
        return 40;
    }

    public static int eventsStreamIdEncodingLength() {
        return 4;
    }

    public static String eventsStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int eventsStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int eventsStreamIdMinValue() {
        return -2147483647;
    }

    public static int eventsStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder eventsStreamId(int value) {
        this.buffer.putInt(this.offset + 40, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int headerLengthId() {
        return 8;
    }

    public static int headerLengthSinceVersion() {
        return 1;
    }

    public static int headerLengthEncodingOffset() {
        return 44;
    }

    public static int headerLengthEncodingLength() {
        return 4;
    }

    public static String headerLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int headerLengthNullValue() {
        return 0;
    }

    public static int headerLengthMinValue() {
        return -2147483647;
    }

    public static int headerLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder headerLength(int value) {
        this.buffer.putInt(this.offset + 44, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int errorBufferLengthId() {
        return 9;
    }

    public static int errorBufferLengthSinceVersion() {
        return 1;
    }

    public static int errorBufferLengthEncodingOffset() {
        return 48;
    }

    public static int errorBufferLengthEncodingLength() {
        return 4;
    }

    public static String errorBufferLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int errorBufferLengthNullValue() {
        return 0;
    }

    public static int errorBufferLengthMinValue() {
        return -2147483647;
    }

    public static int errorBufferLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MarkFileHeaderEncoder errorBufferLength(int value) {
        this.buffer.putInt(this.offset + 48, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int controlChannelId() {
        return 10;
    }

    public static String controlChannelCharacterEncoding() {
        return "US-ASCII";
    }

    public static String controlChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int controlChannelHeaderLength() {
        return 4;
    }

    public MarkFileHeaderEncoder putControlChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder putControlChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder controlChannel(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MarkFileHeaderEncoder controlChannel(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int localControlChannelId() {
        return 11;
    }

    public static String localControlChannelCharacterEncoding() {
        return "US-ASCII";
    }

    public static String localControlChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int localControlChannelHeaderLength() {
        return 4;
    }

    public MarkFileHeaderEncoder putLocalControlChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder putLocalControlChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder localControlChannel(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MarkFileHeaderEncoder localControlChannel(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int eventsChannelId() {
        return 12;
    }

    public static String eventsChannelCharacterEncoding() {
        return "US-ASCII";
    }

    public static String eventsChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int eventsChannelHeaderLength() {
        return 4;
    }

    public MarkFileHeaderEncoder putEventsChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder putEventsChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder eventsChannel(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MarkFileHeaderEncoder eventsChannel(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public static int aeronDirectoryId() {
        return 13;
    }

    public static String aeronDirectoryCharacterEncoding() {
        return "US-ASCII";
    }

    public static String aeronDirectoryMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int aeronDirectoryHeaderLength() {
        return 4;
    }

    public MarkFileHeaderEncoder putAeronDirectory(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder putAeronDirectory(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MarkFileHeaderEncoder aeronDirectory(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MarkFileHeaderEncoder aeronDirectory(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        MarkFileHeaderDecoder decoder = new MarkFileHeaderDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 128, 1);
        return decoder.appendTo(builder);
    }
}

