/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.CommonContext;
import io.aeron.archive.Archive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.archive.codecs.mark.MarkFileHeaderEncoder;
import io.aeron.archive.codecs.mark.VarAsciiEncodingEncoder;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.MarkFile;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;

public class ArchiveMarkFile
implements AutoCloseable {
    public static final int MAJOR_VERSION = 3;
    public static final int MINOR_VERSION = 1;
    public static final int PATCH_VERSION = 0;
    public static final int SEMANTIC_VERSION = SemanticVersion.compose((int)3, (int)1, (int)0);
    public static final int HEADER_LENGTH = 8192;
    public static final String FILENAME = "archive-mark.dat";
    public static final String LINK_FILENAME = "archive-mark.lnk";
    private final MarkFileHeaderDecoder headerDecoder = new MarkFileHeaderDecoder();
    private final MarkFileHeaderEncoder headerEncoder = new MarkFileHeaderEncoder();
    private final MarkFile markFile;
    private final UnsafeBuffer buffer;
    private final UnsafeBuffer errorBuffer;

    ArchiveMarkFile(Archive.Context ctx) {
        this(new File(ctx.markFileDir(), FILENAME), ArchiveMarkFile.alignedTotalFileLength(ctx), ctx.errorBufferLength(), ctx.epochClock(), Archive.Configuration.LIVENESS_TIMEOUT_MS);
        this.encode(ctx);
        this.updateActivityTimestamp(ctx.epochClock().time());
    }

    ArchiveMarkFile(File file, int totalFileLength, int errorBufferLength, EpochClock epochClock, long timeoutMs) {
        boolean markFileExists = file.exists();
        this.markFile = new MarkFile(file, markFileExists, MarkFileHeaderDecoder.versionEncodingOffset(), MarkFileHeaderDecoder.activityTimestampEncodingOffset(), totalFileLength, timeoutMs, epochClock, ArchiveMarkFile::validateVersion, null);
        this.buffer = this.markFile.buffer();
        this.errorBuffer = errorBufferLength > 0 ? new UnsafeBuffer((DirectBuffer)this.buffer, 8192, errorBufferLength) : new UnsafeBuffer((DirectBuffer)this.buffer, 0, 0);
        this.headerEncoder.wrap((MutableDirectBuffer)this.buffer, 0);
        this.headerDecoder.wrap((DirectBuffer)this.buffer, 0, 128, 1);
        if (markFileExists) {
            if (this.buffer.capacity() != totalFileLength) {
                throw new ArchiveException("ArchiveMarkFile capacity=" + this.buffer.capacity() + " < expectedCapacity=" + totalFileLength);
            }
            int existingErrorBufferLength = this.headerDecoder.errorBufferLength();
            if (existingErrorBufferLength > 0) {
                UnsafeBuffer existingErrorBuffer = new UnsafeBuffer((DirectBuffer)this.buffer, this.headerDecoder.headerLength(), existingErrorBufferLength);
                ArchiveMarkFile.saveExistingErrors(file, (AtomicBuffer)existingErrorBuffer, CommonContext.fallbackLogger());
                existingErrorBuffer.setMemory(0, existingErrorBufferLength, (byte)0);
            }
        }
        this.headerEncoder.pid(SystemUtil.getPid());
    }

    public ArchiveMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, Consumer<String> logger) {
        this(directory, filename, epochClock, timeoutMs, ArchiveMarkFile::validateVersion, logger);
    }

    public ArchiveMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, IntConsumer versionCheck, Consumer<String> logger) {
        this.markFile = new MarkFile(directory, filename, MarkFileHeaderDecoder.versionEncodingOffset(), MarkFileHeaderDecoder.activityTimestampEncodingOffset(), timeoutMs, epochClock, versionCheck, logger);
        this.buffer = this.markFile.buffer();
        this.headerEncoder.wrap((MutableDirectBuffer)this.buffer, 0);
        this.headerDecoder.wrap((DirectBuffer)this.buffer, 0, 128, 1);
        this.errorBuffer = this.headerDecoder.errorBufferLength() > 0 ? new UnsafeBuffer((DirectBuffer)this.buffer, this.headerDecoder.headerLength(), this.headerDecoder.errorBufferLength()) : new UnsafeBuffer((DirectBuffer)this.buffer, 0, 0);
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.markFile);
    }

    public void signalReady() {
        this.markFile.signalReady(SEMANTIC_VERSION);
    }

    public void updateActivityTimestamp(long nowMs) {
        if (!this.markFile.isClosed()) {
            this.markFile.timestampOrdered(nowMs);
        }
    }

    public long activityTimestampVolatile() {
        return this.markFile.timestampVolatile();
    }

    public MarkFileHeaderEncoder encoder() {
        return this.headerEncoder;
    }

    public MarkFileHeaderDecoder decoder() {
        return this.headerDecoder;
    }

    public AtomicBuffer errorBuffer() {
        return this.errorBuffer;
    }

    public static void saveExistingErrors(File markFile, AtomicBuffer errorBuffer, PrintStream logger) {
        CommonContext.saveExistingErrors((File)markFile, (AtomicBuffer)errorBuffer, (PrintStream)logger, (String)"archive");
    }

    public static boolean isArchiveMarkFile(Path path, BasicFileAttributes attributes) {
        return path.getFileName().toString().equals(FILENAME);
    }

    public File parentDirectory() {
        return this.markFile.parentDirectory();
    }

    private static int alignedTotalFileLength(Archive.Context ctx) {
        int headerLength = 128 + 4 * VarAsciiEncodingEncoder.lengthEncodingLength() + (null != ctx.controlChannel() ? ctx.controlChannel().length() : 0) + ctx.localControlChannel().length() + (null != ctx.recordingEventsChannel() ? ctx.recordingEventsChannel().length() : 0) + ctx.aeronDirectoryName().length();
        if (headerLength > 8192) {
            throw new ArchiveException("ArchiveMarkFile headerLength=" + headerLength + " > headerLengthCapacity=" + 8192);
        }
        return 8192 + ctx.errorBufferLength();
    }

    String aeronDirectory() {
        this.headerDecoder.sbeRewind();
        this.headerDecoder.skipControlChannel();
        this.headerDecoder.skipLocalControlChannel();
        this.headerDecoder.skipEventsChannel();
        return this.headerDecoder.aeronDirectory();
    }

    private void encode(Archive.Context ctx) {
        this.headerEncoder.startTimestamp(ctx.epochClock().time()).controlStreamId(ctx.controlStreamId()).localControlStreamId(ctx.localControlStreamId()).eventsStreamId(ctx.recordingEventsStreamId()).headerLength(8192).errorBufferLength(ctx.errorBufferLength()).controlChannel(ctx.controlChannel()).localControlChannel(ctx.localControlChannel()).eventsChannel(ctx.recordingEventsChannel()).aeronDirectory(ctx.aeronDirectoryName());
    }

    private static void validateVersion(int version) {
        if (SemanticVersion.major((int)version) != 3) {
            throw new IllegalArgumentException("mark file major version " + SemanticVersion.major((int)version) + " does not match software: " + 3);
        }
    }

    public String toString() {
        return "ArchiveMarkFile{markFile=" + this.markFile + '}';
    }
}

