/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs.mark;

import io.aeron.archive.codecs.mark.MessageHeaderDecoder;
import io.aeron.archive.codecs.mark.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class MarkFileHeaderDecoder {
    public static final int BLOCK_LENGTH = 128;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 100;
    public static final int SCHEMA_VERSION = 1;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final MarkFileHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 128;
    }

    public int sbeTemplateId() {
        return 200;
    }

    public int sbeSchemaId() {
        return 100;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public MarkFileHeaderDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public MarkFileHeaderDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (200 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public MarkFileHeaderDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int versionId() {
        return 1;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionEncodingOffset() {
        return 0;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int versionNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int versionMinValue() {
        return -2147483647;
    }

    public static int versionMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int version() {
        return this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int activityTimestampId() {
        return 2;
    }

    public static int activityTimestampSinceVersion() {
        return 0;
    }

    public static int activityTimestampEncodingOffset() {
        return 8;
    }

    public static int activityTimestampEncodingLength() {
        return 8;
    }

    public static String activityTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long activityTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long activityTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long activityTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long activityTimestamp() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int startTimestampId() {
        return 3;
    }

    public static int startTimestampSinceVersion() {
        return 0;
    }

    public static int startTimestampEncodingOffset() {
        return 16;
    }

    public static int startTimestampEncodingLength() {
        return 8;
    }

    public static String startTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long startTimestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long startTimestampMinValue() {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public long startTimestamp() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int pidId() {
        return 4;
    }

    public static int pidSinceVersion() {
        return 0;
    }

    public static int pidEncodingOffset() {
        return 24;
    }

    public static int pidEncodingLength() {
        return 8;
    }

    public static String pidMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long pidNullValue() {
        return Long.MIN_VALUE;
    }

    public static long pidMinValue() {
        return -9223372036854775807L;
    }

    public static long pidMaxValue() {
        return Long.MAX_VALUE;
    }

    public long pid() {
        return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public static int controlStreamIdId() {
        return 5;
    }

    public static int controlStreamIdSinceVersion() {
        return 0;
    }

    public static int controlStreamIdEncodingOffset() {
        return 32;
    }

    public static int controlStreamIdEncodingLength() {
        return 4;
    }

    public static String controlStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int controlStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int controlStreamIdMinValue() {
        return -2147483647;
    }

    public static int controlStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int controlStreamId() {
        return this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static int localControlStreamIdId() {
        return 6;
    }

    public static int localControlStreamIdSinceVersion() {
        return 0;
    }

    public static int localControlStreamIdEncodingOffset() {
        return 36;
    }

    public static int localControlStreamIdEncodingLength() {
        return 4;
    }

    public static String localControlStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int localControlStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int localControlStreamIdMinValue() {
        return -2147483647;
    }

    public static int localControlStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int localControlStreamId() {
        return this.buffer.getInt(this.offset + 36, ByteOrder.LITTLE_ENDIAN);
    }

    public static int eventsStreamIdId() {
        return 7;
    }

    public static int eventsStreamIdSinceVersion() {
        return 0;
    }

    public static int eventsStreamIdEncodingOffset() {
        return 40;
    }

    public static int eventsStreamIdEncodingLength() {
        return 4;
    }

    public static String eventsStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int eventsStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int eventsStreamIdMinValue() {
        return -2147483647;
    }

    public static int eventsStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int eventsStreamId() {
        return this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN);
    }

    public static int headerLengthId() {
        return 8;
    }

    public static int headerLengthSinceVersion() {
        return 1;
    }

    public static int headerLengthEncodingOffset() {
        return 44;
    }

    public static int headerLengthEncodingLength() {
        return 4;
    }

    public static String headerLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int headerLengthNullValue() {
        return 0;
    }

    public static int headerLengthMinValue() {
        return -2147483647;
    }

    public static int headerLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int headerLength() {
        if (this.parentMessage.actingVersion < 1) {
            return 0;
        }
        return this.buffer.getInt(this.offset + 44, ByteOrder.LITTLE_ENDIAN);
    }

    public static int errorBufferLengthId() {
        return 9;
    }

    public static int errorBufferLengthSinceVersion() {
        return 1;
    }

    public static int errorBufferLengthEncodingOffset() {
        return 48;
    }

    public static int errorBufferLengthEncodingLength() {
        return 4;
    }

    public static String errorBufferLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int errorBufferLengthNullValue() {
        return 0;
    }

    public static int errorBufferLengthMinValue() {
        return -2147483647;
    }

    public static int errorBufferLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int errorBufferLength() {
        if (this.parentMessage.actingVersion < 1) {
            return 0;
        }
        return this.buffer.getInt(this.offset + 48, ByteOrder.LITTLE_ENDIAN);
    }

    public static int controlChannelId() {
        return 10;
    }

    public static int controlChannelSinceVersion() {
        return 0;
    }

    public static String controlChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String controlChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int controlChannelHeaderLength() {
        return 4;
    }

    public int controlChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipControlChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getControlChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getControlChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapControlChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String controlChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getControlChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int localControlChannelId() {
        return 11;
    }

    public static int localControlChannelSinceVersion() {
        return 0;
    }

    public static String localControlChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String localControlChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int localControlChannelHeaderLength() {
        return 4;
    }

    public int localControlChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipLocalControlChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getLocalControlChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getLocalControlChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapLocalControlChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String localControlChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getLocalControlChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int eventsChannelId() {
        return 12;
    }

    public static int eventsChannelSinceVersion() {
        return 0;
    }

    public static String eventsChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String eventsChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int eventsChannelHeaderLength() {
        return 4;
    }

    public int eventsChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipEventsChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getEventsChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getEventsChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapEventsChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String eventsChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getEventsChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public static int aeronDirectoryId() {
        return 13;
    }

    public static int aeronDirectorySinceVersion() {
        return 0;
    }

    public static String aeronDirectoryCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String aeronDirectoryMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int aeronDirectoryHeaderLength() {
        return 4;
    }

    public int aeronDirectoryLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipAeronDirectory() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getAeronDirectory(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getAeronDirectory(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapAeronDirectory(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String aeronDirectory() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getAeronDirectory(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        MarkFileHeaderDecoder decoder = new MarkFileHeaderDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[MarkFileHeader](sbeTemplateId=");
        builder.append(200);
        builder.append("|sbeSchemaId=");
        builder.append(100);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 128) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(128);
        builder.append("):");
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("activityTimestamp=");
        builder.append(this.activityTimestamp());
        builder.append('|');
        builder.append("startTimestamp=");
        builder.append(this.startTimestamp());
        builder.append('|');
        builder.append("pid=");
        builder.append(this.pid());
        builder.append('|');
        builder.append("controlStreamId=");
        builder.append(this.controlStreamId());
        builder.append('|');
        builder.append("localControlStreamId=");
        builder.append(this.localControlStreamId());
        builder.append('|');
        builder.append("eventsStreamId=");
        builder.append(this.eventsStreamId());
        builder.append('|');
        builder.append("headerLength=");
        builder.append(this.headerLength());
        builder.append('|');
        builder.append("errorBufferLength=");
        builder.append(this.errorBufferLength());
        builder.append('|');
        builder.append("controlChannel=");
        builder.append('\'');
        this.getControlChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("localControlChannel=");
        builder.append('\'');
        this.getLocalControlChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("eventsChannel=");
        builder.append('\'');
        this.getEventsChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("aeronDirectory=");
        builder.append('\'');
        this.getAeronDirectory(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public MarkFileHeaderDecoder sbeSkip() {
        this.sbeRewind();
        this.skipControlChannel();
        this.skipLocalControlChannel();
        this.skipEventsChannel();
        this.skipAeronDirectory();
        return this;
    }
}

