/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.status;

import io.aeron.Aeron;
import io.aeron.Counter;
import io.aeron.archive.ArchiveCounters;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class RecordingPos {
    public static final int RECORDING_POSITION_TYPE_ID = 100;
    public static final long NULL_RECORDING_ID = -1L;
    public static final String NAME = "rec-pos";
    private static final int RECORDING_ID_OFFSET = 0;
    private static final int SESSION_ID_OFFSET = 8;
    private static final int SOURCE_IDENTITY_LENGTH_OFFSET = 12;
    private static final int SOURCE_IDENTITY_OFFSET = 16;

    public static Counter allocate(Aeron aeron, UnsafeBuffer tempBuffer, long archiveId, long recordingId, int sessionId, int streamId, String strippedChannel, String sourceIdentity) {
        tempBuffer.putLong(0, recordingId);
        tempBuffer.putInt(8, sessionId);
        int sourceIdentityLength = Math.min(sourceIdentity.length(), 88);
        tempBuffer.putInt(12, sourceIdentityLength);
        tempBuffer.putStringWithoutLengthAscii(16, sourceIdentity, 0, sourceIdentityLength);
        int archiveIdOffset = 16 + sourceIdentityLength;
        tempBuffer.putLong(archiveIdOffset, archiveId);
        int keyLength = archiveIdOffset + 8;
        int labelOffset = BitUtil.align((int)keyLength, (int)4);
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset, "rec-pos: ");
        labelLength += tempBuffer.putLongAscii(labelOffset + labelLength, recordingId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putIntAscii(labelOffset + labelLength, sessionId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putIntAscii(labelOffset + labelLength, streamId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, strippedChannel, 0, 380 - labelLength - ArchiveCounters.lengthOfArchiveIdLabel(archiveId));
        labelLength += ArchiveCounters.appendArchiveIdLabel((MutableDirectBuffer)tempBuffer, labelOffset + labelLength, archiveId);
        return aeron.addCounter(100, (DirectBuffer)tempBuffer, 0, keyLength, (DirectBuffer)tempBuffer, labelOffset, labelLength);
    }

    public static int findCounterIdByRecording(CountersReader countersReader, long recordingId) {
        AtomicBuffer buffer = countersReader.metaDataBuffer();
        int size = countersReader.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = countersReader.getCounterState(i);
            if (1 == counterState) {
                if (countersReader.getCounterTypeId(i) != 100 || buffer.getLong(CountersReader.metaDataOffset((int)i) + 16 + 0) != recordingId) continue;
                return i;
            }
            if (0 == counterState) break;
        }
        return -1;
    }

    public static int findCounterIdBySession(CountersReader countersReader, int sessionId) {
        AtomicBuffer buffer = countersReader.metaDataBuffer();
        int size = countersReader.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = countersReader.getCounterState(i);
            if (1 == counterState) {
                if (countersReader.getCounterTypeId(i) != 100 || buffer.getInt(CountersReader.metaDataOffset((int)i) + 16 + 8) != sessionId) continue;
                return i;
            }
            if (0 == counterState) break;
        }
        return -1;
    }

    public static long getRecordingId(CountersReader countersReader, int counterId) {
        if (countersReader.getCounterState(counterId) == 1 && countersReader.getCounterTypeId(counterId) == 100) {
            return countersReader.metaDataBuffer().getLong(CountersReader.metaDataOffset((int)counterId) + 16 + 0);
        }
        return -1L;
    }

    public static String getSourceIdentity(CountersReader counters, int counterId) {
        if (counters.getCounterState(counterId) == 1 && counters.getCounterTypeId(counterId) == 100) {
            int recordOffset = CountersReader.metaDataOffset((int)counterId);
            return counters.metaDataBuffer().getStringAscii(recordOffset + 16 + 12);
        }
        return null;
    }

    public static boolean isActive(CountersReader counters, int counterId, long recordingId) {
        int recordingIdOffset = CountersReader.metaDataOffset((int)counterId) + 16 + 0;
        return counters.getCounterState(counterId) == 1 && counters.getCounterTypeId(counterId) == 100 && counters.metaDataBuffer().getLong(recordingIdOffset) == recordingId;
    }
}

