/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;
import io.aeron.archive.client.ArchiveEvent;
import io.aeron.archive.codecs.RecordingSignal;
import java.io.File;
import java.util.ArrayDeque;
import org.agrona.ErrorHandler;

class DeleteSegmentsSession
implements Session {
    private final long recordingId;
    private final long correlationId;
    private final ArrayDeque<File> files;
    private final ControlSession controlSession;
    private final ControlResponseProxy controlResponseProxy;
    private final ErrorHandler errorHandler;

    DeleteSegmentsSession(long recordingId, long correlationId, ArrayDeque<File> files, ControlSession controlSession, ControlResponseProxy controlResponseProxy, ErrorHandler errorHandler) {
        this.recordingId = recordingId;
        this.correlationId = correlationId;
        this.files = files;
        this.controlSession = controlSession;
        this.controlResponseProxy = controlResponseProxy;
        this.errorHandler = errorHandler;
    }

    @Override
    public void close() {
        while (!this.files.isEmpty()) {
            File file = this.files.pollFirst();
            if (null == file || !file.exists() || file.delete()) continue;
            this.errorHandler.onError((Throwable)((Object)new ArchiveEvent("segment delete failed for recording: " + this.recordingId)));
        }
    }

    @Override
    public void abort() {
    }

    @Override
    public boolean isDone() {
        return this.files.isEmpty();
    }

    @Override
    public long sessionId() {
        return this.recordingId;
    }

    @Override
    public int doWork() {
        int workCount = 0;
        File file = this.files.pollFirst();
        if (null != file) {
            if (file.exists() && !file.delete()) {
                String errorMessage = "unable to delete segment file: " + file;
                this.controlSession.attemptErrorResponse(this.correlationId, errorMessage, this.controlResponseProxy);
                this.errorHandler.onError((Throwable)((Object)new ArchiveEvent("segment delete failed for recording: " + this.recordingId)));
            }
            if (this.files.isEmpty()) {
                this.controlSession.sendSignal(this.correlationId, this.recordingId, -1L, -1L, RecordingSignal.DELETE);
            }
            ++workCount;
        }
        return workCount;
    }
}

