/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.checksum;

import io.aeron.archive.checksum.Checksum;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.zip.CRC32;
import org.agrona.LangUtil;

final class Crc32
implements Checksum {
    private static final MethodHandle UPDATE_BYTE_BUFFER;
    public static final Crc32 INSTANCE;

    private Crc32() {
    }

    @Override
    public int compute(long address, int offset, int length) {
        try {
            return UPDATE_BYTE_BUFFER.invokeExact(address, offset, length);
        }
        catch (Throwable t) {
            LangUtil.rethrowUnchecked((Throwable)t);
            return -1;
        }
    }

    static {
        try {
            Method method = CRC32.class.getDeclaredMethod("updateByteBuffer0", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
            UPDATE_BYTE_BUFFER = methodHandle = MethodHandles.insertArguments(methodHandle, 0, 0);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
        INSTANCE = new Crc32();
    }
}

