/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Catalog;
import io.aeron.archive.CatalogIndex;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;
import org.agrona.concurrent.UnsafeBuffer;

abstract class AbstractListRecordingsSession
implements Session {
    static final int MAX_SCANS_PER_WORK_CYCLE = 64;
    private final UnsafeBuffer descriptorBuffer;
    private final Catalog catalog;
    private final int count;
    private final ControlSession controlSession;
    private final long correlationId;
    private long recordingId;
    private int sent;
    private boolean isDone = false;

    AbstractListRecordingsSession(long correlationId, long fromRecordingId, int count, Catalog catalog, ControlSession controlSession, UnsafeBuffer descriptorBuffer) {
        this.correlationId = correlationId;
        this.recordingId = fromRecordingId;
        this.count = count;
        this.controlSession = controlSession;
        this.catalog = catalog;
        this.descriptorBuffer = descriptorBuffer;
    }

    @Override
    public void abort(String reason) {
        this.isDone = true;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public long sessionId() {
        return -1L;
    }

    @Override
    public int doWork() {
        if (this.isDone) {
            return 0;
        }
        CatalogIndex catalogIndex = this.catalog.index();
        int lastPosition = catalogIndex.lastPosition();
        long[] index = catalogIndex.index();
        int position = CatalogIndex.find(index, this.recordingId, lastPosition);
        if (position < 0) {
            for (int i = 0; i <= lastPosition; i += 2) {
                if (index[i] < this.recordingId) continue;
                position = i;
                break;
            }
        }
        int batchStartPosition = position;
        for (int recordsScanned = 0; this.sent < this.count && recordsScanned < 64; ++recordsScanned) {
            boolean noMoreRecordings;
            boolean bl = noMoreRecordings = position < 0 || position > lastPosition;
            if (noMoreRecordings || this.catalog.wrapDescriptorAtOffset(this.descriptorBuffer, (int)index[position + 1]) < 0) {
                this.controlSession.sendRecordingUnknown(this.correlationId, noMoreRecordings ? this.recordingId : index[position]);
                this.isDone = true;
                break;
            }
            if (this.acceptDescriptor(this.descriptorBuffer)) {
                this.controlSession.sendDescriptor(this.correlationId, this.descriptorBuffer);
                ++this.sent;
            }
            this.recordingId = position < lastPosition ? index[position + 2] : ++this.recordingId;
            position += 2;
        }
        if (this.sent == this.count) {
            this.isDone = true;
        }
        return (position - batchStartPosition) / 2;
    }

    @Override
    public void close() {
        this.controlSession.activeListing(null);
    }

    abstract boolean acceptDescriptor(UnsafeBuffer var1);
}

