/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.AeronCounters;
import io.aeron.Counter;
import org.agrona.AsciiEncoding;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class ArchiveCounters {
    static final String ARCHIVE_ID_LABEL_PREFIX = " - archiveId=";

    private ArchiveCounters() {
    }

    public static Counter allocate(Aeron aeron, MutableDirectBuffer tempBuffer, int typeId, String name, long archiveId) {
        int index = 0;
        tempBuffer.putLong(index, archiveId);
        int keyLength = index += 8;
        index += tempBuffer.putStringWithoutLengthAscii(index, name);
        index += ArchiveCounters.appendArchiveIdLabel(tempBuffer, index, archiveId);
        return aeron.addCounter(typeId, (DirectBuffer)tempBuffer, 0, keyLength, (DirectBuffer)tempBuffer, keyLength, index - keyLength);
    }

    static Counter allocateErrorCounter(Aeron aeron, MutableDirectBuffer tempBuffer, long archiveId) {
        int index = 0;
        tempBuffer.putLong(index, archiveId);
        int keyLength = index += 8;
        index += tempBuffer.putStringWithoutLengthAscii(index, "Archive Errors");
        index += ArchiveCounters.appendArchiveIdLabel(tempBuffer, index, archiveId);
        index += AeronCounters.appendVersionInfo((MutableDirectBuffer)tempBuffer, (int)index, (String)"1.48.0", (String)"d800d60405");
        return aeron.addCounter(101, (DirectBuffer)tempBuffer, 0, keyLength, (DirectBuffer)tempBuffer, keyLength, index - keyLength);
    }

    public static int appendArchiveIdLabel(MutableDirectBuffer tempBuffer, int offset, long archiveId) {
        int suffixLength = 0;
        suffixLength += tempBuffer.putStringWithoutLengthAscii(offset, ARCHIVE_ID_LABEL_PREFIX);
        suffixLength += tempBuffer.putLongAscii(offset + suffixLength, archiveId);
        return suffixLength;
    }

    public static int lengthOfArchiveIdLabel(long archiveId) {
        if (archiveId < 0L) {
            return Long.MIN_VALUE == archiveId ? ARCHIVE_ID_LABEL_PREFIX.length() + AsciiEncoding.MIN_LONG_VALUE.length : ARCHIVE_ID_LABEL_PREFIX.length() + 1 + AsciiEncoding.digitCount((long)(-archiveId));
        }
        return ARCHIVE_ID_LABEL_PREFIX.length() + AsciiEncoding.digitCount((long)archiveId);
    }

    public static int find(CountersReader counters, int typeId, long archiveId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        int size = counters.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = counters.getCounterState(i);
            if (1 == counterState) {
                if (counters.getCounterTypeId(i) != typeId || buffer.getLong(CountersReader.metaDataOffset((int)i) + 16) != archiveId) continue;
                return i;
            }
            if (0 == counterState) break;
        }
        return -1;
    }
}

