/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class ControlResponseDecoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 11;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ControlResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 11;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ControlResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ControlResponseDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (1 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ControlResponseDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long controlSessionId() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public static int relevantIdId() {
        return 3;
    }

    public static int relevantIdSinceVersion() {
        return 0;
    }

    public static int relevantIdEncodingOffset() {
        return 16;
    }

    public static int relevantIdEncodingLength() {
        return 8;
    }

    public static String relevantIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long relevantIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long relevantIdMinValue() {
        return -9223372036854775807L;
    }

    public static long relevantIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long relevantId() {
        return this.buffer.getLong(this.offset + 16, BYTE_ORDER);
    }

    public static int codeId() {
        return 4;
    }

    public static int codeSinceVersion() {
        return 0;
    }

    public static int codeEncodingOffset() {
        return 24;
    }

    public static int codeEncodingLength() {
        return 4;
    }

    public static String codeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int codeRaw() {
        return this.buffer.getInt(this.offset + 24, BYTE_ORDER);
    }

    public ControlResponseCode code() {
        return ControlResponseCode.get(this.buffer.getInt(this.offset + 24, BYTE_ORDER));
    }

    public static int versionId() {
        return 5;
    }

    public static int versionSinceVersion() {
        return 4;
    }

    public static int versionEncodingOffset() {
        return 28;
    }

    public static int versionEncodingLength() {
        return 4;
    }

    public static String versionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int versionNullValue() {
        return 0;
    }

    public static int versionMinValue() {
        return 2;
    }

    public static int versionMaxValue() {
        return 0xFFFFFF;
    }

    public int version() {
        if (this.parentMessage.actingVersion < 4) {
            return 0;
        }
        return this.buffer.getInt(this.offset + 28, BYTE_ORDER);
    }

    public static int errorMessageId() {
        return 6;
    }

    public static int errorMessageSinceVersion() {
        return 0;
    }

    public static String errorMessageCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String errorMessageMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int errorMessageHeaderLength() {
        return 4;
    }

    public int errorMessageLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipErrorMessage() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getErrorMessage(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getErrorMessage(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapErrorMessage(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String errorMessage() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getErrorMessage(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ControlResponseDecoder decoder = new ControlResponseDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ControlResponse](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(101);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 11) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(11);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 32) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(32);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("relevantId=");
        builder.append(this.relevantId());
        builder.append('|');
        builder.append("code=");
        builder.append((Object)this.code());
        builder.append('|');
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("errorMessage=");
        builder.append('\'');
        this.getErrorMessage(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public ControlResponseDecoder sbeSkip() {
        this.sbeRewind();
        this.skipErrorMessage();
        return this;
    }
}

