/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Publication;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Int2ObjectHashMap;

public class ActivePublications {
    private final Map<String, Int2ObjectHashMap<Publication>> publicationsByChannelMap = new HashMap<String, Int2ObjectHashMap<Publication>>();

    public Publication get(String channel, int streamId) {
        Int2ObjectHashMap<Publication> publicationByStreamIdMap = this.publicationsByChannelMap.get(channel);
        if (null == publicationByStreamIdMap) {
            return null;
        }
        return (Publication)publicationByStreamIdMap.get(streamId);
    }

    public Publication put(String channel, int streamId, Publication publication) {
        Int2ObjectHashMap publicationByStreamIdMap = (Int2ObjectHashMap)CollectionUtil.getOrDefault(this.publicationsByChannelMap, (Object)channel, ignore -> new Int2ObjectHashMap());
        return (Publication)publicationByStreamIdMap.put(streamId, (Object)publication);
    }

    public Publication remove(String channel, int streamId) {
        Int2ObjectHashMap<Publication> publicationByStreamIdMap = this.publicationsByChannelMap.get(channel);
        if (null == publicationByStreamIdMap) {
            return null;
        }
        Publication publication = (Publication)publicationByStreamIdMap.remove(streamId);
        if (publicationByStreamIdMap.isEmpty()) {
            this.publicationsByChannelMap.remove(channel);
        }
        return publication;
    }

    public void close() {
        this.publicationsByChannelMap.values().stream().flatMap(publicationByStreamIdMap -> publicationByStreamIdMap.values().stream()).collect(Collectors.toList()).forEach(Publication::release);
    }
}

