/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ActivePublications;
import io.aeron.ActiveSubscriptions;
import io.aeron.AvailableImageHandler;
import io.aeron.DriverListener;
import io.aeron.DriverListenerAdapter;
import io.aeron.DriverProxy;
import io.aeron.ErrorCode;
import io.aeron.Image;
import io.aeron.LogBuffersFactory;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import io.aeron.exceptions.RegistrationException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.ManagedResource;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;

class ClientConductor
implements Agent,
DriverListener {
    private static final long NO_CORRELATION_ID = -1L;
    private static final long RESOURCE_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(1L);
    private static final long RESOURCE_LINGER_NS = TimeUnit.SECONDS.toNanos(5L);
    private final long keepAliveIntervalNs;
    private final long driverTimeoutMs;
    private final long driverTimeoutNs;
    private final long interServiceTimeoutNs;
    private final long publicationConnectionTimeoutMs;
    private long timeOfLastKeepalive;
    private long timeOfLastCheckResources;
    private long timeOfLastWork;
    private volatile boolean driverActive = true;
    private final EpochClock epochClock;
    private final FileChannel.MapMode imageMapMode;
    private final NanoClock nanoClock;
    private final DriverListenerAdapter driverListener;
    private final LogBuffersFactory logBuffersFactory;
    private final ActivePublications activePublications = new ActivePublications();
    private final ActiveSubscriptions activeSubscriptions = new ActiveSubscriptions();
    private final ArrayList<ManagedResource> lingeringResources = new ArrayList();
    private final UnsafeBuffer counterValuesBuffer;
    private final DriverProxy driverProxy;
    private final ErrorHandler errorHandler;
    private final AvailableImageHandler availableImageHandler;
    private final UnavailableImageHandler unavailableImageHandler;
    private RegistrationException driverException;

    ClientConductor(EpochClock epochClock, NanoClock nanoClock, CopyBroadcastReceiver broadcastReceiver, LogBuffersFactory logBuffersFactory, UnsafeBuffer counterValuesBuffer, DriverProxy driverProxy, ErrorHandler errorHandler, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler, FileChannel.MapMode imageMapMode, long keepAliveIntervalNs, long driverTimeoutMs, long interServiceTimeoutNs, long publicationConnectionTimeoutMs) {
        this.epochClock = epochClock;
        this.nanoClock = nanoClock;
        this.timeOfLastKeepalive = nanoClock.nanoTime();
        this.timeOfLastCheckResources = nanoClock.nanoTime();
        this.timeOfLastWork = nanoClock.nanoTime();
        this.errorHandler = errorHandler;
        this.counterValuesBuffer = counterValuesBuffer;
        this.driverProxy = driverProxy;
        this.logBuffersFactory = logBuffersFactory;
        this.availableImageHandler = availableImageHandler;
        this.unavailableImageHandler = unavailableImageHandler;
        this.imageMapMode = imageMapMode;
        this.keepAliveIntervalNs = keepAliveIntervalNs;
        this.driverTimeoutMs = driverTimeoutMs;
        this.driverTimeoutNs = TimeUnit.MILLISECONDS.toNanos(driverTimeoutMs);
        this.interServiceTimeoutNs = interServiceTimeoutNs;
        this.publicationConnectionTimeoutMs = publicationConnectionTimeoutMs;
        this.driverListener = new DriverListenerAdapter(broadcastReceiver, this);
    }

    public synchronized void onClose() {
        this.activePublications.close();
        this.activeSubscriptions.close();
        Thread.yield();
        this.lingeringResources.forEach(ManagedResource::delete);
    }

    public synchronized int doWork() {
        return this.doWork(-1L, null);
    }

    public String roleName() {
        return "aeron-client-conductor";
    }

    synchronized Publication addPublication(String channel, int streamId) {
        this.verifyDriverIsActive();
        Publication publication = this.activePublications.get(channel, streamId);
        if (publication == null) {
            long correlationId = this.driverProxy.addPublication(channel, streamId);
            this.awaitResponse(correlationId, channel, true);
            publication = this.activePublications.get(channel, streamId);
        }
        publication.incRef();
        return publication;
    }

    synchronized void releasePublication(Publication publication) {
        this.verifyDriverIsActive();
        if (publication == this.activePublications.remove(publication.channel(), publication.streamId())) {
            long correlationId = this.driverProxy.removePublication(publication.registrationId());
            this.lingerResource(publication.managedResource());
            this.awaitResponse(correlationId, publication.channel(), false);
        }
    }

    synchronized Subscription addSubscription(String channel, int streamId) {
        this.verifyDriverIsActive();
        long correlationId = this.driverProxy.addSubscription(channel, streamId);
        Subscription subscription = new Subscription(this, channel, streamId, correlationId);
        this.activeSubscriptions.add(subscription);
        this.awaitResponse(correlationId, channel, true);
        return subscription;
    }

    synchronized void releaseSubscription(Subscription subscription) {
        this.verifyDriverIsActive();
        long correlationId = this.driverProxy.removeSubscription(subscription.registrationId());
        this.awaitResponse(correlationId, subscription.channel(), false);
        this.activeSubscriptions.remove(subscription);
    }

    @Override
    public void onNewPublication(String channel, int streamId, int sessionId, int publicationLimitId, String logFileName, long correlationId) {
        Publication publication = new Publication(this, channel, streamId, sessionId, (ReadablePosition)new UnsafeBufferPosition(this.counterValuesBuffer, publicationLimitId), this.logBuffersFactory.map(logFileName, FileChannel.MapMode.READ_WRITE), correlationId);
        this.activePublications.put(channel, streamId, publication);
    }

    @Override
    public void onAvailableImage(int streamId, int sessionId, Long2LongHashMap subscriberPositionMap, String logFileName, String sourceIdentity, long correlationId) {
        this.activeSubscriptions.forEach(streamId, subscription -> {
            long positionId;
            if (!subscription.hasImage(correlationId) && -1L != (positionId = subscriberPositionMap.get(subscription.registrationId()))) {
                Image image = new Image((Subscription)subscription, sessionId, (Position)new UnsafeBufferPosition(this.counterValuesBuffer, (int)positionId), this.logBuffersFactory.map(logFileName, this.imageMapMode), this.errorHandler, sourceIdentity, correlationId);
                subscription.addImage(image);
                this.availableImageHandler.onAvailableImage(image);
            }
        });
    }

    @Override
    public void onError(ErrorCode errorCode, String message, long correlationId) {
        this.driverException = new RegistrationException(errorCode, message);
    }

    @Override
    public void onUnavailableImage(int streamId, long correlationId) {
        this.activeSubscriptions.forEach(streamId, subscription -> {
            Image image = subscription.removeImage(correlationId);
            if (null != image) {
                this.unavailableImageHandler.onUnavailableImage(image);
            }
        });
    }

    DriverListenerAdapter driverListenerAdapter() {
        return this.driverListener;
    }

    void lingerResource(ManagedResource managedResource) {
        managedResource.timeOfLastStateChange(this.nanoClock.nanoTime());
        this.lingeringResources.add(managedResource);
    }

    boolean isPublicationConnected(long timeOfLastStatusMessage) {
        return this.epochClock.time() <= timeOfLastStatusMessage + this.publicationConnectionTimeoutMs;
    }

    UnavailableImageHandler unavailableImageHandler() {
        return this.unavailableImageHandler;
    }

    private void checkDriverHeartbeat() {
        long now = this.epochClock.time();
        long currentDriverKeepaliveTime = this.driverProxy.timeOfLastDriverKeepalive();
        if (this.driverActive && now > currentDriverKeepaliveTime + this.driverTimeoutMs) {
            this.driverActive = false;
            String msg = String.format("Driver has been inactive for over %dms", this.driverTimeoutMs);
            this.errorHandler.onError((Throwable)new DriverTimeoutException(msg));
        }
    }

    private void verifyDriverIsActive() {
        if (!this.driverActive) {
            throw new DriverTimeoutException("Driver is inactive");
        }
    }

    private int doWork(long correlationId, String expectedChannel) {
        int workCount = 0;
        try {
            workCount += this.onCheckTimeouts();
            workCount += this.driverListener.pollMessage(correlationId, expectedChannel);
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
        return workCount;
    }

    private void awaitResponse(long correlationId, String expectedChannel, boolean isSlowOperation) {
        this.driverException = null;
        long timeout = this.nanoClock.nanoTime() + this.driverTimeoutNs;
        do {
            if (isSlowOperation) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    LangUtil.rethrowUnchecked((Throwable)ex);
                }
            } else {
                Thread.yield();
            }
            this.doWork(correlationId, expectedChannel);
            if (this.driverListener.lastReceivedCorrelationId() != correlationId) continue;
            if (null != this.driverException) {
                throw this.driverException;
            }
            return;
        } while (this.nanoClock.nanoTime() < timeout);
        throw new DriverTimeoutException("No response from driver within timeout");
    }

    private int onCheckTimeouts() {
        long now = this.nanoClock.nanoTime();
        int result = 0;
        if (now > this.timeOfLastWork + this.interServiceTimeoutNs) {
            this.onClose();
            throw new ConductorServiceTimeoutException(String.format("Timeout between service calls over %dns", this.interServiceTimeoutNs));
        }
        this.timeOfLastWork = now;
        if (now > this.timeOfLastKeepalive + this.keepAliveIntervalNs) {
            this.driverProxy.sendClientKeepalive();
            this.checkDriverHeartbeat();
            this.timeOfLastKeepalive = now;
            ++result;
        }
        if (now > this.timeOfLastCheckResources + RESOURCE_TIMEOUT_NS) {
            for (int i = this.lingeringResources.size() - 1; i >= 0; --i) {
                ManagedResource resource = this.lingeringResources.get(i);
                if (now <= resource.timeOfLastStateChange() + RESOURCE_LINGER_NS) continue;
                this.lingeringResources.remove(i);
                resource.delete();
            }
            this.timeOfLastCheckResources = now;
            ++result;
        }
        return result;
    }
}

