/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.Image;
import io.aeron.SubscriptionRhsPadding;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.RawBlockHandler;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.collections.ArrayUtil;

public class Subscription
extends SubscriptionRhsPadding
implements AutoCloseable {
    private static final Image[] EMPTY_ARRAY = new Image[0];
    private final long registrationId;
    private final int streamId;
    private volatile boolean isClosed = false;
    private volatile Image[] images = EMPTY_ARRAY;
    private final ClientConductor clientConductor;
    private final String channel;

    Subscription(ClientConductor conductor, String channel, int streamId, long registrationId) {
        this.clientConductor = conductor;
        this.channel = channel;
        this.streamId = streamId;
        this.registrationId = registrationId;
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public int poll(FragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public int controlledPoll(ControlledFragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public long blockPoll(BlockHandler blockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.blockPoll(blockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public long rawPoll(RawBlockHandler rawBlockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.rawPoll(rawBlockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public int imageCount() {
        return this.images.length;
    }

    public Image imageBySessionId(int sessionId) {
        Image result = null;
        for (Image image : this.images) {
            if (sessionId != image.sessionId()) continue;
            result = image;
            break;
        }
        return result;
    }

    public List<Image> images() {
        return Arrays.asList(this.images);
    }

    public void forEachImage(Consumer<Image> imageConsumer) {
        for (Image image : this.images) {
            imageConsumer.accept(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ClientConductor clientConductor = this.clientConductor;
        synchronized (clientConductor) {
            if (!this.isClosed) {
                this.isClosed = true;
                this.clientConductor.releaseSubscription(this);
                for (Image image : this.images) {
                    this.clientConductor.unavailableImageHandler().onUnavailableImage(image);
                    this.clientConductor.lingerResource(image.managedResource());
                }
                this.images = EMPTY_ARRAY;
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long registrationId() {
        return this.registrationId;
    }

    void addImage(Image image) {
        if (this.isClosed) {
            this.clientConductor.lingerResource(image.managedResource());
        } else {
            this.images = (Image[])ArrayUtil.add((Object[])this.images, (Object)image);
        }
    }

    Image removeImage(long correlationId) {
        Object[] oldArray = this.images;
        Image removedImage = null;
        for (Image image : oldArray) {
            if (image.correlationId() != correlationId) continue;
            removedImage = image;
            break;
        }
        if (null != removedImage) {
            this.images = (Image[])ArrayUtil.remove((Object[])oldArray, removedImage);
            this.clientConductor.lingerResource(removedImage.managedResource());
        }
        return removedImage;
    }

    boolean hasImage(long correlationId) {
        boolean hasImage = false;
        for (Image image : this.images) {
            if (correlationId != image.correlationId()) continue;
            hasImage = true;
            break;
        }
        return hasImage;
    }

    boolean hasNoImages() {
        return this.images.length == 0;
    }
}

