/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import org.agrona.MutableDirectBuffer;

public class ImageBuffersReadyFlyweight {
    private static final int CORRELATION_ID_OFFSET = 0;
    private static final int SESSION_ID_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int SUBSCRIBER_POSITION_BLOCK_LENGTH_OFFSET = 16;
    private static final int SUBSCRIBER_POSITION_COUNT_OFFSET = 20;
    private static final int SUBSCRIBER_POSITIONS_OFFSET = 24;
    private static final int SUBSCRIBER_POSITION_BLOCK_LENGTH = 12;
    private MutableDirectBuffer buffer;
    private int offset;

    public final ImageBuffersReadyFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0);
    }

    public ImageBuffersReadyFlyweight correlationId(long correlationId) {
        this.buffer.putLong(this.offset + 0, correlationId);
        return this;
    }

    public int sessionId() {
        return this.buffer.getInt(this.offset + 8);
    }

    public ImageBuffersReadyFlyweight sessionId(int sessionId) {
        this.buffer.putInt(this.offset + 8, sessionId);
        return this;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 12);
    }

    public ImageBuffersReadyFlyweight streamId(int streamId) {
        this.buffer.putInt(this.offset + 12, streamId);
        return this;
    }

    public int subscriberPositionCount() {
        return this.buffer.getInt(this.offset + 20);
    }

    public ImageBuffersReadyFlyweight subscriberPositionCount(int value) {
        this.buffer.putInt(this.offset + 16, 12);
        this.buffer.putInt(this.offset + 20, value);
        return this;
    }

    public ImageBuffersReadyFlyweight subscriberPositionId(int index, int id) {
        this.buffer.putInt(this.offset + this.subscriberPositionOffset(index), id);
        return this;
    }

    public int subscriberPositionId(int index) {
        return this.buffer.getInt(this.offset + this.subscriberPositionOffset(index));
    }

    public ImageBuffersReadyFlyweight positionIndicatorRegistrationId(int index, long id) {
        this.buffer.putLong(this.offset + this.subscriberPositionOffset(index) + 4, id);
        return this;
    }

    public long positionIndicatorRegistrationId(int index) {
        return this.buffer.getLong(this.offset + this.subscriberPositionOffset(index) + 4);
    }

    public String logFileName() {
        return this.buffer.getStringUtf8(this.offset + this.logFileNameOffset());
    }

    public ImageBuffersReadyFlyweight logFileName(String logFileName) {
        this.buffer.putStringUtf8(this.offset + this.logFileNameOffset(), logFileName);
        return this;
    }

    public String sourceIdentity() {
        return this.buffer.getStringUtf8(this.offset + this.sourceIdentityOffset());
    }

    public ImageBuffersReadyFlyweight sourceIdentity(String value) {
        this.buffer.putStringUtf8(this.offset + this.sourceIdentityOffset(), value);
        return this;
    }

    public int length() {
        int sourceIdentityOffset = this.sourceIdentityOffset();
        return sourceIdentityOffset + this.buffer.getInt(this.offset + sourceIdentityOffset) + 4;
    }

    private int subscriberPositionOffset(int index) {
        return 24 + index * 12;
    }

    private int logFileNameOffset() {
        return this.subscriberPositionOffset(this.subscriberPositionCount());
    }

    private int sourceIdentityOffset() {
        int logFileNameOffset = this.logFileNameOffset();
        return logFileNameOffset + this.buffer.getInt(this.offset + logFileNameOffset) + 4;
    }
}

