/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBufferDescriptor {
    public static final int PARTITION_COUNT = 3;
    public static final int LOG_META_DATA_SECTION_INDEX = 3;
    public static final int TERM_MIN_LENGTH = 65536;
    public static final int TERM_TAIL_COUNTERS_OFFSET;
    public static final int LOG_ACTIVE_PARTITION_INDEX_OFFSET;
    public static final int LOG_TIME_OF_LAST_SM_OFFSET;
    public static final int LOG_INITIAL_TERM_ID_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET;
    public static final int LOG_MTU_LENGTH_OFFSET;
    public static final int LOG_CORRELATION_ID_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_MAX_LENGTH = 128;
    public static final int LOG_META_DATA_LENGTH;

    public static void checkTermLength(int termLength) {
        if (termLength < 65536) {
            String s = String.format("Term length less than min length of %d, length=%d", 65536, termLength);
            throw new IllegalStateException(s);
        }
        if ((termLength & 0x1F) != 0) {
            String s = String.format("Term length not a multiple of %d, length=%d", 32, termLength);
            throw new IllegalStateException(s);
        }
    }

    public static int initialTermId(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getInt(LOG_INITIAL_TERM_ID_OFFSET);
    }

    public static void initialTermId(UnsafeBuffer logMetaDataBuffer, int initialTermId) {
        logMetaDataBuffer.putInt(LOG_INITIAL_TERM_ID_OFFSET, initialTermId);
    }

    public static int mtuLength(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getInt(LOG_MTU_LENGTH_OFFSET);
    }

    public static void mtuLength(UnsafeBuffer logMetaDataBuffer, int mtuLength) {
        logMetaDataBuffer.putInt(LOG_MTU_LENGTH_OFFSET, mtuLength);
    }

    public static long correlationId(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getLong(LOG_CORRELATION_ID_OFFSET);
    }

    public static void correlationId(UnsafeBuffer logMetaDataBuffer, long id) {
        logMetaDataBuffer.putLong(LOG_CORRELATION_ID_OFFSET, id);
    }

    public static long timeOfLastStatusMessage(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getLongVolatile(LOG_TIME_OF_LAST_SM_OFFSET);
    }

    public static void timeOfLastStatusMessage(UnsafeBuffer logMetaDataBuffer, long timeInMillis) {
        logMetaDataBuffer.putLongOrdered(LOG_TIME_OF_LAST_SM_OFFSET, timeInMillis);
    }

    public static int activePartitionIndex(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getIntVolatile(LOG_ACTIVE_PARTITION_INDEX_OFFSET);
    }

    public static void activePartitionIndex(UnsafeBuffer logMetaDataBuffer, int activePartitionIndex) {
        logMetaDataBuffer.putIntOrdered(LOG_ACTIVE_PARTITION_INDEX_OFFSET, activePartitionIndex);
    }

    public static int nextPartitionIndex(int currentIndex) {
        return (currentIndex + 1) % 3;
    }

    public static int indexByTerm(int initialTermId, int activeTermId) {
        return (activeTermId - initialTermId) % 3;
    }

    public static int indexByTermCount(long termCount) {
        return (int)(termCount % 3L);
    }

    public static int indexByPosition(long position, int positionBitsToShift) {
        return (int)((position >>> positionBitsToShift) % 3L);
    }

    public static long computePosition(int activeTermId, int termOffset, int positionBitsToShift, int initialTermId) {
        long termCount = activeTermId - initialTermId;
        return (termCount << positionBitsToShift) + (long)termOffset;
    }

    public static long computeTermBeginPosition(int activeTermId, int positionBitsToShift, int initialTermId) {
        long termCount = activeTermId - initialTermId;
        return termCount << positionBitsToShift;
    }

    public static int computeTermIdFromPosition(long position, int positionBitsToShift, int initialTermId) {
        return (int)(position >>> positionBitsToShift) + initialTermId;
    }

    public static int computeTermOffsetFromPosition(long position, int positionBitsToShift) {
        long mask = (1L << positionBitsToShift) - 1L;
        return (int)(position & mask);
    }

    public static long computeLogLength(int termLength) {
        return termLength * 3 + LOG_META_DATA_LENGTH;
    }

    public static int computeTermLength(long logLength) {
        return (int)((logLength - (long)LOG_META_DATA_LENGTH) / 3L);
    }

    public static void storeDefaultFrameHeader(UnsafeBuffer logMetaDataBuffer, DirectBuffer defaultHeader) {
        if (defaultHeader.capacity() != 32) {
            throw new IllegalArgumentException(String.format("Default header of %d not equal to %d", defaultHeader.capacity(), 32));
        }
        logMetaDataBuffer.putInt(LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET, 32);
        logMetaDataBuffer.putBytes(LOG_DEFAULT_FRAME_HEADER_OFFSET, defaultHeader, 0, 32);
    }

    public static UnsafeBuffer defaultFrameHeader(UnsafeBuffer logMetaDataBuffer) {
        return new UnsafeBuffer((DirectBuffer)logMetaDataBuffer, LOG_DEFAULT_FRAME_HEADER_OFFSET, 32);
    }

    public static void applyDefaultHeader(UnsafeBuffer logMetaDataBuffer, UnsafeBuffer termBuffer, int termOffset) {
        termBuffer.putBytes(termOffset, (DirectBuffer)logMetaDataBuffer, LOG_DEFAULT_FRAME_HEADER_OFFSET, 32);
    }

    public static void rotateLog(UnsafeBuffer logMetaDataBuffer, int activePartitionIndex, int termId) {
        int nextIndex = LogBufferDescriptor.nextPartitionIndex(activePartitionIndex);
        LogBufferDescriptor.initialiseTailWithTermId(logMetaDataBuffer, nextIndex, termId);
        LogBufferDescriptor.activePartitionIndex(logMetaDataBuffer, nextIndex);
    }

    public static void initialiseTailWithTermId(UnsafeBuffer logMetaData, int partitionIndex, int termId) {
        logMetaData.putLong(TERM_TAIL_COUNTERS_OFFSET + partitionIndex * 8, (long)termId << 32);
    }

    public static int termId(long rawTail) {
        return (int)(rawTail >>> 32);
    }

    public static int termOffset(long rawTail, long termLength) {
        long tail = rawTail & 0xFFFFFFFFL;
        return (int)Math.min(tail, termLength);
    }

    public static long rawTailVolatile(UnsafeBuffer logMetaDataBuffer, int partitionIndex) {
        return logMetaDataBuffer.getLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex);
    }

    public static long rawTailVolatile(UnsafeBuffer logMetaDataBuffer) {
        int partitionIndex = LogBufferDescriptor.activePartitionIndex(logMetaDataBuffer);
        return logMetaDataBuffer.getLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex);
    }

    static {
        int offset;
        TERM_TAIL_COUNTERS_OFFSET = offset = 0;
        LOG_ACTIVE_PARTITION_INDEX_OFFSET = offset += 24;
        LOG_TIME_OF_LAST_SM_OFFSET = offset = 128;
        LOG_CORRELATION_ID_OFFSET = offset += 128;
        LOG_INITIAL_TERM_ID_OFFSET = LOG_CORRELATION_ID_OFFSET + 8;
        LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET = LOG_INITIAL_TERM_ID_OFFSET + 4;
        LOG_MTU_LENGTH_OFFSET = LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET + 4;
        LOG_DEFAULT_FRAME_HEADER_OFFSET = offset += 64;
        LOG_META_DATA_LENGTH = offset + 128;
    }
}

