/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class HeaderFlyweight
extends UnsafeBuffer {
    public static final byte[] EMPTY_BUFFER = new byte[0];
    public static final int HDR_TYPE_PAD = 0;
    public static final int HDR_TYPE_DATA = 1;
    public static final int HDR_TYPE_NAK = 2;
    public static final int HDR_TYPE_SM = 3;
    public static final int HDR_TYPE_ERR = 4;
    public static final int HDR_TYPE_SETUP = 5;
    public static final int HDR_TYPE_EXT = 65535;
    public static final byte CURRENT_VERSION = 0;
    public static final int FRAME_LENGTH_FIELD_OFFSET = 0;
    public static final int VERSION_FIELD_OFFSET = 4;
    public static final int FLAGS_FIELD_OFFSET = 5;
    public static final int TYPE_FIELD_OFFSET = 6;
    public static final int HEADER_LENGTH = 8;

    public HeaderFlyweight() {
        super(EMPTY_BUFFER);
    }

    public HeaderFlyweight(UnsafeBuffer buffer) {
        super((DirectBuffer)buffer);
    }

    public HeaderFlyweight(ByteBuffer buffer) {
        super(buffer);
    }

    public short version() {
        return (short)(this.getByte(4) & 0xFF);
    }

    public HeaderFlyweight version(short version) {
        this.putByte(4, (byte)version);
        return this;
    }

    public short flags() {
        return (short)(this.getByte(5) & 0xFF);
    }

    public HeaderFlyweight flags(short flags) {
        this.putByte(5, (byte)flags);
        return this;
    }

    public int headerType() {
        return this.getShort(6, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public HeaderFlyweight headerType(int type) {
        this.putShort(6, (short)type, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int frameLength() {
        return this.getInt(0, ByteOrder.LITTLE_ENDIAN);
    }

    public HeaderFlyweight frameLength(int length) {
        this.putInt(0, length, ByteOrder.LITTLE_ENDIAN);
        return this;
    }
}

