/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import java.util.Arrays;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class BufferBuilder {
    public static final int INITIAL_CAPACITY = 4096;
    private final MutableDirectBuffer mutableDirectBuffer;
    private byte[] buffer;
    private int limit = 0;
    private int capacity;

    public BufferBuilder() {
        this(4096);
    }

    public BufferBuilder(int initialCapacity) {
        this.capacity = BitUtil.findNextPositivePowerOfTwo((int)initialCapacity);
        this.buffer = new byte[this.capacity];
        this.mutableDirectBuffer = new UnsafeBuffer(this.buffer);
    }

    public int capacity() {
        return this.capacity;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        if (limit < 0 || limit >= this.capacity) {
            throw new IllegalArgumentException(String.format("Limit outside range: capacity=%d limit=%d", this.capacity, limit));
        }
        this.limit = limit;
    }

    public MutableDirectBuffer buffer() {
        return this.mutableDirectBuffer;
    }

    public BufferBuilder reset() {
        this.limit = 0;
        return this;
    }

    public BufferBuilder compact() {
        this.capacity = Math.max(4096, BitUtil.findNextPositivePowerOfTwo((int)this.limit));
        this.buffer = Arrays.copyOf(this.buffer, this.capacity);
        this.mutableDirectBuffer.wrap(this.buffer);
        return this;
    }

    public BufferBuilder append(DirectBuffer srcBuffer, int srcOffset, int length) {
        this.ensureCapacity(length);
        srcBuffer.getBytes(srcOffset, this.buffer, this.limit, length);
        this.limit += length;
        return this;
    }

    private void ensureCapacity(int additionalCapacity) {
        int requiredCapacity = this.limit + additionalCapacity;
        if (requiredCapacity < 0) {
            String s = String.format("Insufficient capacity: limit=%d additional=%d", this.limit, additionalCapacity);
            throw new IllegalStateException(s);
        }
        if (requiredCapacity > this.capacity) {
            int newCapacity = BufferBuilder.findSuitableCapacity(this.capacity, requiredCapacity);
            byte[] newBuffer = Arrays.copyOf(this.buffer, newCapacity);
            this.capacity = newCapacity;
            this.buffer = newBuffer;
            this.mutableDirectBuffer.wrap(newBuffer);
        }
    }

    private static int findSuitableCapacity(int capacity, int requiredCapacity) {
        while ((capacity <<= 1) < requiredCapacity) {
        }
        return capacity;
    }
}

